/**
 * AbstractTextEditorPanelWithSyntaxHighlighting.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.core;

import javax.swing.text.Document;

import adams.core.Properties;
import adams.gui.scripting.SyntaxDocument;


/**
 * A panel that allows the editing of text, including undo/redo support,
 * and custom syntax highlighting.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3814 $
 */
public abstract class AbstractTextEditorPanelWithSyntaxHighlighting
  extends StyledTextEditorPanel {

  /** for serialization. */
  private static final long serialVersionUID = 7416099580088156868L;

  /**
   * Returns the syntax style definition.
   *
   * @return		the props file with the definitions
   */
  protected abstract Properties getStyleProperties();

  /**
   * Returns a new text pane.
   *
   * @return		the text pane
   */
  protected BaseTextPane newBaseTextPane() {
    BaseTextPane	result;
    Document		doc;

    result = new BaseTextPane();
    doc    = new SyntaxDocument(getStyleProperties());
    result.setDocument(doc);

    return result;
  }
}
