/*
 * ScriptingInfoEvent.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.event;


import java.util.EventObject;

import adams.gui.scripting.AbstractScriptingEngine;

/**
 * Gets sent when a scripting event happened.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3507 $
 */
public class ScriptingInfoEvent
  extends EventObject {

  /** for serialization. */
  private static final long serialVersionUID = 5373990735194119669L;

  /** the command that was run. */
  protected String m_Cmd;

  /**
   * Initializes the object.
   *
   * @param engine	the scripting engine that ran the command
   * @param cmd		the command that was run
   */
  public ScriptingInfoEvent(AbstractScriptingEngine engine, String cmd) {
    super(engine);

    m_Cmd = cmd;
  }

  /**
   * Returns the scripting engine that triggered the event.
   *
   * @return		the engine
   */
  public AbstractScriptingEngine getScriptingEngine() {
    return (AbstractScriptingEngine) getSource();
  }

  /**
   * Checks whether a command is available or not (= idle).
   *
   * @return		true if command available
   */
  public boolean hasCmd() {
    return (m_Cmd != null);
  }

  /**
   * Returns the command that was run.
   *
   * @return		the command
   */
  public String getCmd() {
    return m_Cmd;
  }

  /**
   * Returns a string representation of the event object.
   *
   * @return		the string representation
   */
  public String toString() {
    StringBuffer	result;

    result = new StringBuffer(super.toString());
    result.deleteCharAt(result.length() - 1);

    result.append(",engine=" + getSource());
    result.append(",cmd=" + m_Cmd);
    result.append("]");

    return result.toString();
  }
}
