/**
 * ActorTreeTab.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.flow.tab;

import java.awt.BorderLayout;

import adams.gui.core.BaseScrollPane;
import adams.gui.flow.ActorTreePanel;

/**
 * Shows all available actors in a class tree.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3908 $
 */
public class ActorTreeTab
  extends AbstractEditorTab {

  /** for serialization. */
  private static final long serialVersionUID = 5660819043419968252L;

  /** the panel with the actors. */
  protected ActorTreePanel m_ActorTreePanel;

  /**
   * Initializes the widgets.
   */
  protected void initGUI() {
    super.initGUI();

    setLayout(new BorderLayout());

    m_ActorTreePanel = new ActorTreePanel();
    add(new BaseScrollPane(m_ActorTreePanel), BorderLayout.CENTER);
  }

  /**
   * Returns the title of the tab.
   *
   * @return		the title
   */
  public String getTitle() {
    return "Actors";
  }
}
