/**
 * AbstractVisibilityScriplet.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.scripting;

import adams.core.Range;
import adams.gui.visualization.container.Container;
import adams.gui.visualization.container.ContainerManager;
import adams.gui.visualization.container.VisibilityContainer;

/**
 * Ancestor for visibility-related scriptlets.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 1641 $
 */
public abstract class AbstractVisibilityScriplet
  extends AbstractDataContainerPanelScriptlet {

  /** for serialization. */
  private static final long serialVersionUID = 8803594650276164515L;

  /**
   * Returns a one-line listing of the options of the action.
   *
   * @return		the options or null if none
   */
  protected String getOptionsDescription() {
    return "<comma-separated list of 1-based indices (or ranges of indices)>";
  }

  /**
   * Processes the options.
   *
   * @param options	additional/optional options for the action
   * @param visible	whether to make them visible or not
   * @return		null if no error, otherwise error message
   * @throws Exception 	if something goes wrong
   */
  protected String process(String options, boolean visible) throws Exception {
    int			i;
    int[]		indices;
    Container		cont;
    ContainerManager	manager;
    Range		range;

    manager = getDataContainerPanel().getContainerManager();
    range   = new Range(options);
    range.setMax(manager.count());
    indices = range.getIntIndices();
    if (indices.length > 1) {
      manager.startUpdate();
      for (i = 0; i < indices.length; i++) {
	cont  = manager.get(indices[i]);
	if (cont instanceof VisibilityContainer)
	  ((VisibilityContainer) cont).setVisible(visible);
      }
      manager.finishUpdate();
    }
    else if (indices.length == 1) {
      cont = manager.get(indices[0]);
      if (cont instanceof VisibilityContainer)
	((VisibilityContainer) cont).setVisible(visible);
    }

    return null;
  }
}
