/**
 * Disconnect.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.scripting;

/**
 <!-- scriptlet-parameters-start -->
 * Action parameters:<br/>
 * <pre>   disconnect</pre>
 * <p/>
 <!-- scriptlet-parameters-end -->
 *
 <!-- scriptlet-description-start -->
 * Description:
 * <pre>   Disconnects from the database.</pre>
 * <p/>
 <!-- scriptlet-description-end -->
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 1870 $
 */
public class Disconnect
  extends AbstractDatabaseScriptlet {

  /** for serialization. */
  private static final long serialVersionUID = 2760286358879561274L;

  /** the action to execute. */
  public final static String ACTION = "disconnect";

  /**
   * Returns the action string used in the command processor.
   *
   * @return		<!-- scriptlet-action-start -->disconnect<!-- scriptlet-action-end -->
   */
  public String getAction() {
    return ACTION;
  }

  /**
   * Returns the full description of the action.
   *
   * @return		the full description
   */
  public String getDescription() {
    return "Disconnects from the database.";
  }

  /**
   * Processes the options.
   *
   * @param options	additional/optional options for the action
   * @return		null if no error, otherwise error message
   * @throws Exception 	if something goes wrong
   */
  public String process(String options) throws Exception {
    if (getDatabaseConnection().isConnected())
      getDatabaseConnection().disconnect();

    if (getDatabaseConnection().isConnected())
      return "Failed to disconnect from database!";

    return null;
  }
}
