/*
 * Paintlet.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.visualization.core;


import java.awt.Graphics;

import adams.gui.event.PaintEvent.PaintMoment;

/**
 * An interface for paintlets.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3932 $
 */
public interface Paintlet {

  /**
   * Sets the spectrum panel to use, null to disable painting.
   *
   * @param value	the panel to paint on
   */
  public void setPanel(PaintablePanel value);

  /**
   * Returns the spectrum panel currently in use.
   *
   * @return		the panel in use
   */
  public PaintablePanel getPanel();

  /**
   * Returns whether a panel has been set.
   *
   * @return		true if a panel is currently set
   */
  public boolean hasPanel();

  /**
   * Returns the plot panel of the panel, null if no panel present.
   *
   * @return		the plot panel
   */
  public PlotPanel getPlot();

  /**
   * Sets whether the paintlet is enabled or not. Setting it to true
   * automatically initiates a repaint. Is not affected by m_RepaintOnChange.
   *
   * @param value	if true then the paintlet is enabled
   * @see		#m_RepaintOnChange
   */
  public void setEnabled(boolean value);

  /**
   * Returns whether the paintlet is currently enabled.
   *
   * @return		true if the paintlet is enabled.
   */
  public boolean isEnabled();

  /**
   * Sets whether the paintlet reacts with repaints to changes of its members.
   *
   * @param value	if true then the paintlet repaints whenever members
   * 			get changed
   */
  public void setRepaintOnChange(boolean value);

  /**
   * Returns whether the paintlet reacts with repaints to changes of its members.
   *
   * @return		true if paintlet repaints whenever members get changed
   */
  public boolean getRepaintOnChange();

  /**
   * Returns when this paintlet is to be executed.
   *
   * @return		when this paintlet is to be executed
   */
  public PaintMoment getPaintMoment();

  /**
   * The paint routine of the paintlet.
   *
   * @param g		the graphics context to use for painting
   */
  public void performPaint(Graphics g);

  /**
   * The paint routine of the paintlet.
   *
   * @param g		the graphics context to use for painting
   * @see		#isEnabled()
   */
  public void paint(Graphics g);
}
