/**
 * ImageOverlay.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.visualization.image;

import java.awt.Graphics;

import adams.gui.visualization.image.ImagePanel.PaintPanel;

/**
 * Interface for classes that put overlays over an image.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3943 $
 */
public interface ImageOverlay {

  /**
   * Paints the overlay over the image.
   *
   * @param panel	the panel this overlay is for
   * @param g		the graphics context
   */
  public void paintOverlay(PaintPanel panel, Graphics g);
}
