/**
 * PaintletWithFixedXRange.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.visualization.sequence;

/**
 * Interface for paintlets that use a fixed X range.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2913 $
 */
public interface PaintletWithFixedXRange {

  /**
   * Returns the minimum to use for the X range.
   *
   * @return		the minimum
   */
  public double getMinX();

  /**
   * Returns the maximum to use for the X range.
   *
   * @return		the maximum
   */
  public double getMaxX();
}
