/*
 * XYSequenceTableColumnNameGenerator.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.visualization.sequence;

import adams.gui.visualization.container.DefaultContainerTableColumnNameGenerator;

/**
 * Abstract class for generating the column names of a table.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 385 $
 */
public class XYSequenceTableColumnNameGenerator
  extends DefaultContainerTableColumnNameGenerator {

  /** for serialization. */
  private static final long serialVersionUID = -272225674632479848L;

  /**
   * Returns the name of the column with the actual data in it.
   *
   * @return		the name
   */
  public String getData() {
    return "ID";
  }

  /**
   * Returns the width of the data column.
   *
   * @return		the width
   */
  public int getDataWidth() {
    return 80;
  }
}