/* The following code was generated by JFlex 1.4.2 on 11/25/11 9:16 AM */

/*
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * Scanner.java
 * Copyright (C) 2009-2010 University of Waikato, Hamilton, New Zealand
 */

package adams.parser.actorsuggestion;

import java_cup.runtime.SymbolFactory;
import java.io.*;
import java.util.*;

/**
 * A scanner for parsing actor suggestion rules.
 *
 * @author FracPete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4079 $
 */

public class Scanner implements java_cup.runtime.Scanner {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int STRING = 2;
  public static final int YYINITIAL = 0;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1, 1
  };

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = {
     0,  0,  0,  0,  0,  0,  0,  0,  0, 21, 28,  0, 21, 24,  0,  0, 
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
    21,  0, 22,  0, 19,  0,  0,  0,  0,  0,  0,  0,  0,  0, 20,  0, 
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
     0,  1,  4, 15,  3,  5,  6, 19, 18, 11, 19, 17, 13, 16,  2,  7, 
    10, 19,  8, 12,  9, 14, 19, 19, 19, 19, 19,  0, 23,  0,  0, 19, 
     0, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 26, 19, 
    19, 19, 27, 19, 25, 19, 19, 19, 19, 19, 19,  0,  0,  0,  0,  0
  };

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\2\0\1\1\11\2\1\3\1\4\1\5\1\6\1\7"+
    "\2\2\1\0\6\2\1\10\1\11\3\2\1\12\1\13"+
    "\1\14\1\15\1\16\1\2\1\17\17\2\1\20\1\21"+
    "\5\2\1\22\1\23\1\2\1\24\6\2\1\25\1\2"+
    "\1\26\1\2\1\27\1\30\2\2\1\31\6\2\1\32"+
    "\1\33";

  private static int [] zzUnpackAction() {
    int [] result = new int[87];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\35\0\72\0\127\0\164\0\221\0\256\0\313"+
    "\0\350\0\u0105\0\u0122\0\u013f\0\72\0\72\0\u015c\0\72"+
    "\0\u0179\0\u0196\0\u01b3\0\u01d0\0\u01ed\0\u020a\0\u0227\0\u0244"+
    "\0\u0261\0\u027e\0\221\0\u029b\0\u02b8\0\u02d5\0\u02f2\0\72"+
    "\0\72\0\72\0\72\0\221\0\u030f\0\221\0\u032c\0\u0349"+
    "\0\u0366\0\u0383\0\u03a0\0\u03bd\0\u03da\0\u03f7\0\u0414\0\u0431"+
    "\0\u044e\0\u046b\0\u0488\0\u04a5\0\u04c2\0\221\0\221\0\u04df"+
    "\0\u04fc\0\u0519\0\u0536\0\u0553\0\221\0\221\0\u0570\0\221"+
    "\0\u058d\0\u05aa\0\u05c7\0\u05e4\0\u0601\0\u061e\0\221\0\u063b"+
    "\0\221\0\u0658\0\221\0\221\0\u0675\0\u0692\0\221\0\u06af"+
    "\0\u06cc\0\u06e9\0\u0706\0\u0723\0\u0740\0\221\0\221";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[87];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\3\1\4\1\5\1\6\1\7\1\6\1\10\2\6"+
    "\1\11\1\12\1\13\1\14\7\6\1\3\1\15\1\16"+
    "\1\3\1\15\3\6\1\15\26\17\1\20\1\21\1\3"+
    "\3\17\37\0\1\6\1\22\3\6\1\23\15\6\1\24"+
    "\4\0\3\6\2\0\6\6\1\25\14\6\1\24\4\0"+
    "\3\6\2\0\23\6\1\24\4\0\3\6\2\0\4\6"+
    "\1\26\16\6\1\24\4\0\3\6\2\0\1\27\22\6"+
    "\1\24\4\0\3\6\2\0\7\6\1\30\11\6\1\31"+
    "\1\6\1\24\4\0\3\6\2\0\1\32\22\6\1\24"+
    "\4\0\3\6\2\0\5\6\1\33\5\6\1\34\7\6"+
    "\1\24\4\0\3\6\2\0\6\6\1\35\1\6\1\36"+
    "\1\6\1\37\10\6\1\24\4\0\3\6\1\0\26\17"+
    "\3\0\3\17\27\0\1\40\2\0\1\41\1\42\1\43"+
    "\2\0\2\6\1\44\20\6\1\24\4\0\3\6\2\0"+
    "\10\6\1\45\12\6\1\24\4\0\3\6\2\0\23\6"+
    "\5\0\3\6\2\0\10\6\1\46\12\6\1\24\4\0"+
    "\3\6\2\0\5\6\1\47\15\6\1\24\4\0\3\6"+
    "\2\0\14\6\1\50\6\6\1\24\4\0\3\6\2\0"+
    "\1\51\14\6\1\52\5\6\1\24\4\0\3\6\2\0"+
    "\4\6\1\53\16\6\1\24\4\0\3\6\2\0\7\6"+
    "\1\54\13\6\1\24\4\0\3\6\2\0\5\6\1\55"+
    "\6\6\1\56\6\6\1\24\4\0\3\6\2\0\15\6"+
    "\1\57\5\6\1\24\4\0\3\6\2\0\1\60\22\6"+
    "\1\24\4\0\3\6\2\0\1\6\1\61\21\6\1\24"+
    "\4\0\3\6\2\0\4\6\1\62\16\6\1\24\4\0"+
    "\3\6\2\0\6\6\1\63\14\6\1\24\4\0\3\6"+
    "\2\0\13\6\1\64\7\6\1\24\4\0\3\6\2\0"+
    "\1\6\1\65\21\6\1\24\4\0\3\6\2\0\4\6"+
    "\1\66\16\6\1\24\4\0\3\6\2\0\1\6\1\67"+
    "\21\6\1\24\4\0\3\6\2\0\4\6\1\70\16\6"+
    "\1\24\4\0\3\6\2\0\12\6\1\71\10\6\1\24"+
    "\4\0\3\6\2\0\1\72\22\6\1\24\4\0\3\6"+
    "\2\0\7\6\1\73\13\6\1\24\4\0\3\6\2\0"+
    "\1\6\1\74\21\6\1\24\4\0\3\6\2\0\20\6"+
    "\1\75\2\6\1\24\4\0\3\6\2\0\7\6\1\76"+
    "\13\6\1\24\4\0\3\6\2\0\7\6\1\77\13\6"+
    "\1\24\4\0\3\6\2\0\4\6\1\100\16\6\1\24"+
    "\4\0\3\6\2\0\13\6\1\101\7\6\1\24\4\0"+
    "\3\6\2\0\1\6\1\102\21\6\1\24\4\0\3\6"+
    "\2\0\7\6\1\103\13\6\1\24\4\0\3\6\2\0"+
    "\13\6\1\104\7\6\1\24\4\0\3\6\2\0\16\6"+
    "\1\105\4\6\1\24\4\0\3\6\2\0\2\6\1\106"+
    "\20\6\1\24\4\0\3\6\2\0\4\6\1\107\16\6"+
    "\1\24\4\0\3\6\2\0\5\6\1\110\15\6\1\24"+
    "\4\0\3\6\2\0\10\6\1\111\12\6\1\24\4\0"+
    "\3\6\2\0\13\6\1\112\7\6\1\24\4\0\3\6"+
    "\2\0\10\6\1\113\12\6\1\24\4\0\3\6\2\0"+
    "\4\6\1\114\16\6\1\24\4\0\3\6\2\0\1\115"+
    "\22\6\1\24\4\0\3\6\2\0\6\6\1\116\14\6"+
    "\1\24\4\0\3\6\2\0\10\6\1\117\12\6\1\24"+
    "\4\0\3\6\2\0\14\6\1\120\6\6\1\24\4\0"+
    "\3\6\2\0\7\6\1\121\13\6\1\24\4\0\3\6"+
    "\2\0\6\6\1\122\14\6\1\24\4\0\3\6\2\0"+
    "\17\6\1\123\3\6\1\24\4\0\3\6\2\0\1\6"+
    "\1\124\21\6\1\24\4\0\3\6\2\0\4\6\1\125"+
    "\16\6\1\24\4\0\3\6\2\0\4\6\1\126\16\6"+
    "\1\24\4\0\3\6\2\0\7\6\1\127\13\6\1\24"+
    "\4\0\3\6\1\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[1885];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\2\0\1\11\11\1\2\11\1\1\1\11\3\1\1\0"+
    "\13\1\4\11\64\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[87];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /* user code: */
  // Author: FracPete (fracpete at waikato dot ac dot nz)
  // Version: $Revision: 4079 $
  protected SymbolFactory sf;

  public Scanner(InputStream r, SymbolFactory sf){
    this(r);
    this.sf = sf;
  }
  StringBuilder string = new StringBuilder();


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public Scanner(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public Scanner(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead > 0) {
      zzEndRead+= numRead;
      return false;
    }
    // unlikely but not impossible: read 0 characters, but not at end of stream    
    if (numRead == 0) {
      int c = zzReader.read();
      if (c == -1) {
        return true;
      } else {
        zzBuffer[zzEndRead++] = (char) c;
        return false;
      }     
    }

	// numRead < 0
    return true;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public java_cup.runtime.Symbol next_token() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 23: 
          { return sf.newSymbol("First",       sym.ISLAST);
          }
        case 28: break;
        case 27: 
          { return sf.newSymbol("Transformer", sym.TRANSFORMER);
          }
        case 29: break;
        case 12: 
          { string.append('\n');
          }
        case 30: break;
        case 24: 
          { return sf.newSymbol("Source",      sym.SOURCE);
          }
        case 31: break;
        case 1: 
          { System.err.println("Illegal character: "+yytext());
          }
        case 32: break;
        case 2: 
          { return sf.newSymbol("Classname", sym.CLASSNAME, new String(yytext()));
          }
        case 33: break;
        case 22: 
          { return sf.newSymbol("Parent" ,     sym.PARENT);
          }
        case 34: break;
        case 20: 
          { return sf.newSymbol("False",       sym.FALSE);
          }
        case 35: break;
        case 25: 
          { return sf.newSymbol("First",       sym.ISFIRST);
          }
        case 36: break;
        case 7: 
          { string.append('\\');
          }
        case 37: break;
        case 8: 
          { return sf.newSymbol("If",          sym.IF);
          }
        case 38: break;
        case 26: 
          { return sf.newSymbol("Standalone",  sym.STANDALONE);
          }
        case 39: break;
        case 4: 
          { string.setLength(0); yybegin(STRING);
          }
        case 40: break;
        case 17: 
          { return sf.newSymbol("Then",        sym.THEN);
          }
        case 41: break;
        case 19: 
          { return sf.newSymbol("After",       sym.AFTER);
          }
        case 42: break;
        case 18: 
          { return sf.newSymbol("Sink",        sym.SINK);
          }
        case 43: break;
        case 21: 
          { return sf.newSymbol("Before",      sym.BEFORE);
          }
        case 44: break;
        case 13: 
          { string.append('\r');
          }
        case 45: break;
        case 16: 
          { return sf.newSymbol("True",        sym.TRUE);
          }
        case 46: break;
        case 15: 
          { return sf.newSymbol("Not",         sym.NOT);
          }
        case 47: break;
        case 5: 
          { string.append(yytext());
          }
        case 48: break;
        case 10: 
          { string.append('\"');
          }
        case 49: break;
        case 6: 
          { yybegin(YYINITIAL);
                  return sf.newSymbol("Classname", sym.CLASSNAME, string.toString());
          }
        case 50: break;
        case 14: 
          { return sf.newSymbol("And",         sym.AND);
          }
        case 51: break;
        case 9: 
          { return sf.newSymbol("Is",          sym.IS);
          }
        case 52: break;
        case 3: 
          { /* ignore white space. */
          }
        case 53: break;
        case 11: 
          { string.append('\t');
          }
        case 54: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
              {     return sf.newSymbol("EOF",sym.EOF);
 }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
