/**
 * BaseDateTimeToStringTest.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */

package adams.data.conversion;

import adams.data.conversion.BaseDateTimeToString;
import adams.test.TmpFile;

/**
 * Tests the BaseDateTimeToString conversion.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3779 $
 */
public class BaseDateTimeToStringTest
  extends AbstractConversionTestCase {

  /**
   * Constructs the test case. Called by subclasses.
   *
   * @param name 	the name of the test
   */
  public BaseDateTimeToStringTest(String name) {
    super(name);
  }

  /**
   * Returns the input data to use in the regression test.
   *
   * @return		the objects
   */
  protected Object[] getRegressionInput() {
    return new String[]{
	"2010-10-10 11:03:01",
	"2010-10-10 23:03:01",
	"2010-10-10 11:03:01 +1 HOUR",
	"2010-10-10 23:03:01 +3 DAY +1 HOUR -4 MINUTE",
	"2010-10-10 23:03:01 +3 DAY +1 HOUR -4 SECOND",
	"2010-10-10 12:03:01 -5 DAY +1 HOUR -1 MINUTE",
	"2010-10-10 23:03:01 -14 DAY +1 HOUR -4 MINUTE",
    };
  }

  /**
   * Returns the setups to use in the regression test.
   *
   * @return		the setups
   */
  protected AbstractConversion[] getRegressionSetups() {
    return new AbstractConversion[]{
	new BaseDateTimeToString()
    };
  }

  /**
   * Returns the ignored line indices to use in the regression test.
   *
   * @return		the setups
   */
  protected int[] getRegressionIgnoredLineIndices() {
    return new int[0];
  }
}
