/**
 * DefaultSimpleReportReaderTest.java
 * Copyright (C) 201 University of Waikato, Hamilton, New Zealand
 */
package adams.data.io.input;

import junit.framework.Test;
import junit.framework.TestSuite;
import adams.data.io.input.AbstractReportReader;
import adams.env.Environment;

/**
 * Test class for the DefaultSimpleReportReader data container. Run from the command line with: <p/>
 * java adams.data.io.input.DefaultSimpleReportReaderTest
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3808 $
 */
public class DefaultSimpleReportReaderTest
  extends AbstractReportReaderTestCase {

  /**
   * Constructs the test case. Called by subclasses.
   *
   * @param name 	the name of the test
   */
  public DefaultSimpleReportReaderTest(String name) {
    super(name);
  }

  /**
   * Returns the filenames (without path) of the input data files to use
   * in the regression test.
   *
   * @return		the filenames
   */
  protected String[] getRegressionInputFiles() {
    return new String[]{
	"simple.report"
    };
  }

  /**
   * Returns the setups to use in the regression test.
   *
   * @return		the setups
   */
  protected AbstractReportReader[] getRegressionSetups() {
    return new AbstractReportReader[]{
	new DefaultSimpleReportReader()
    };
  }

  /**
   * Returns the test suite.
   *
   * @return		the suite
   */
  public static Test suite() {
    return new TestSuite(DefaultSimpleReportReaderTest.class);
  }

  /**
   * Runs the test from commandline.
   *
   * @param args	ignored
   */
  public static void main(String[] args) {
    Environment.setEnvironmentClass(Environment.class);
    runTest(suite());
  }
}
