/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

import adams.core.SortedList;
import adams.env.Environment;
import adams.test.AdamsTestCase;
import java.io.Serializable;
import java.util.Arrays;
import junit.framework.Test;
import junit.framework.TestSuite;

public class SortedListTest
extends AdamsTestCase {
    protected SortedList m_List;

    public SortedListTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_List = new SortedList();
    }

    protected void tearDown() throws Exception {
        this.m_List.clear();
        this.m_List = null;
        super.tearDown();
    }

    protected void performTest(Comparable[] insert, Comparable[] expected) {
        SortedListTest.assertEquals((String)"input and output arrays length differ", (int)expected.length, (int)insert.length);
        for (Comparable c : insert) {
            this.m_List.add((Serializable)((Object)c));
        }
        SortedListTest.assertEquals((String)"number of elements in list are different from expected", (int)expected.length, (int)this.m_List.size());
        for (int i = 0; i < insert.length; ++i) {
            SortedListTest.assertEquals((String)("element #" + (i + 1) + " differs"), (Object)expected[i], (Object)this.m_List.get(i));
        }
    }

    public void testSortedIntegers() {
        this.performTest(new Integer[]{1, 2, 3}, new Integer[]{1, 2, 3});
    }

    public void testUnsortedIntegers() {
        this.performTest(new Integer[]{2, 4, 3, 1}, new Integer[]{1, 2, 3, 4});
    }

    public void testUnsortedDuplicateIntegers() {
        this.performTest(new Integer[]{2, 4, 2, 3, 1, 4}, new Integer[]{1, 2, 2, 3, 4, 4});
    }

    public void testFirstInteger() {
        this.m_List.addAll(Arrays.asList(2, 4, 2, 3, 1, 4));
        SortedListTest.assertEquals((String)"first element differs", (Object)1, (Object)this.m_List.first());
    }

    public void testLastInteger() {
        this.m_List.addAll(Arrays.asList(2, 4, 2, 3, 1, 4));
        SortedListTest.assertEquals((String)"last element differs", (Object)4, (Object)this.m_List.last());
    }

    public void testSortedDoubles() {
        this.performTest(new Double[]{1.0, 2.0, 3.0}, new Double[]{1.0, 2.0, 3.0});
    }

    public void testUnsortedDoubles() {
        this.performTest(new Double[]{2.0, 4.0, 3.0, 1.0}, new Double[]{1.0, 2.0, 3.0, 4.0});
    }

    public void testUnsortedDuplicateDoubles() {
        this.performTest(new Double[]{2.0, 4.0, 2.0, 3.0, 1.0, 4.0}, new Double[]{1.0, 2.0, 2.0, 3.0, 4.0, 4.0});
    }

    public void testFirstDouble() {
        this.m_List.addAll(Arrays.asList(2.0, 4.0, 2.0, 3.0, 1.0, 4.0));
        SortedListTest.assertEquals((String)"first element differs", (Object)1.0, (Object)this.m_List.first());
    }

    public void testLastDouble() {
        this.m_List.addAll(Arrays.asList(2.0, 4.0, 2.0, 3.0, 1.0, 4.0));
        SortedListTest.assertEquals((String)"last element differs", (Object)4.0, (Object)this.m_List.last());
    }

    public void testSortedStrings() {
        this.performTest((Comparable[])new String[]{"1", "2", "3"}, (Comparable[])new String[]{"1", "2", "3"});
    }

    public void testUnsortedStrings() {
        this.performTest((Comparable[])new String[]{"2", "4", "3", "1"}, (Comparable[])new String[]{"1", "2", "3", "4"});
    }

    public void testUnsortedDuplicateStrings() {
        this.performTest((Comparable[])new String[]{"2", "4", "2", "3", "1", "4"}, (Comparable[])new String[]{"1", "2", "2", "3", "4", "4"});
    }

    public void testFirstString() {
        this.m_List.addAll(Arrays.asList("2", "4", "2", "3", "1", "4"));
        SortedListTest.assertEquals((String)"first element differs", (Object)"1", (Object)this.m_List.first());
    }

    public void testLastString() {
        this.m_List.addAll(Arrays.asList("2", "4", "2", "3", "1", "4"));
        SortedListTest.assertEquals((String)"last element differs", (Object)"4", (Object)this.m_List.last());
    }

    public static Test suite() {
        return new TestSuite(SortedListTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        SortedListTest.runTest(SortedListTest.suite());
    }
}

