/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import adams.core.option.AbstractNumericOptionTest;
import adams.core.option.AbstractOptionTest;
import adams.core.option.OptionHandler;
import adams.env.Environment;
import junit.framework.Test;
import junit.framework.TestSuite;

public class ByteOptionTest
extends AbstractNumericOptionTest {
    public ByteOptionTest(String name) {
        super(name);
    }

    protected OptionHandler getOptionHandler() {
        return new ByteOptionClass();
    }

    protected String getLowerBoundTestProperty() {
        return "byteObj";
    }

    protected Byte getLowerBoundTestValue() {
        return new Byte(-30);
    }

    protected String getUpperBoundTestProperty() {
        return "byteObj";
    }

    protected Byte getUpperBoundTestValue() {
        return new Byte(30);
    }

    public static Test suite() {
        return new TestSuite(ByteOptionTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        ByteOptionTest.runTest(ByteOptionTest.suite());
    }

    public static class ByteOptionClass
    extends AbstractOptionTest.AbstractOptionClass {
        private static final long serialVersionUID = -8653800898932789033L;
        protected byte m_BytePrim;
        protected byte[] m_BytePrimArray;
        protected Byte m_ByteObj;
        protected Byte[] m_ByteObjArray;

        public void defineOptions() {
            super.defineOptions();
            this.m_OptionManager.add("byte-prim", "bytePrim", (Object)1);
            this.m_OptionManager.add("byte-prim-array", "bytePrimArray", (Object)new byte[]{1, 2, 3});
            this.m_OptionManager.add("byte-obj", "byteObj", (Object)new Byte(2), (Number)new Byte(-10), (Number)new Byte(10));
            this.m_OptionManager.add("byte-obj-array", "byteObjArray", (Object)new Byte[]{new Byte(4), new Byte(5), new Byte(6)});
        }

        public void setBytePrim(byte value) {
            this.m_BytePrim = value;
        }

        public byte getBytePrim() {
            return this.m_BytePrim;
        }

        public String bytePrimTipText() {
            return "bytePrim";
        }

        public void setBytePrimArray(byte[] value) {
            this.m_BytePrimArray = value;
        }

        public byte[] getBytePrimArray() {
            return this.m_BytePrimArray;
        }

        public String bytePrimArrayTipText() {
            return "bytePrimArray";
        }

        public void setByteObj(Byte value) {
            this.m_ByteObj = value;
        }

        public Byte getByteObj() {
            return this.m_ByteObj;
        }

        public String byteObjTipText() {
            return "byteObj";
        }

        public void setByteObjArray(Byte[] value) {
            this.m_ByteObjArray = value;
        }

        public Byte[] getByteObjArray() {
            return this.m_ByteObjArray;
        }

        public String byteObjArrayTipText() {
            return "byteObjArray";
        }
    }
}

