/*
 * Decompiled with CFR 0.152.
 */
package adams.data;

import adams.core.CleanUpHandler;
import adams.core.Destroyable;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.data.container.DataContainer;
import adams.db.DatabaseConnectionHandler;
import adams.test.AbstractDatabaseTestCase;
import adams.test.AbstractTestHelper;
import adams.test.TestHelper;
import adams.test.TmpFile;
import java.io.File;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDataProcessorTestCase<A, I extends DataContainer, O>
extends AbstractDatabaseTestCase {
    public AbstractDataProcessorTestCase(String name) {
        super(name);
    }

    @Override
    protected AbstractTestHelper<I, O> newTestHelper() {
        return new TestHelper(this, "");
    }

    protected I load(String filename) {
        return this.m_TestHelper.load(filename);
    }

    protected abstract O process(I var1, A var2);

    protected boolean save(O data, String filename) {
        return this.m_TestHelper.save(data, filename);
    }

    protected String[] getRegressionConnections() {
        return null;
    }

    protected abstract String[] getRegressionInputFiles();

    protected abstract A[] getRegressionSetups();

    protected abstract int[] getRegressionIgnoredLineIndices();

    protected String createOutputFilename(String input, int no) {
        String result;
        String ext = "-out" + no;
        int index = input.lastIndexOf(46);
        if (index == -1) {
            result = input + ext;
        } else {
            result = input.substring(0, index);
            result = result + ext;
            result = result + input.substring(index);
        }
        return result;
    }

    public void testDoesntChangeInputData() {
        int i;
        String[] input = this.getRegressionInputFiles();
        A[] setups = this.getRegressionSetups();
        String[] props = this.getRegressionConnections();
        AbstractDataProcessorTestCase.assertEquals((String)"Number of files and setups differ!", (int)input.length, (int)setups.length);
        if (props != null) {
            AbstractDataProcessorTestCase.assertEquals((String)"Number of files and connection setups differ!", (int)input.length, (int)props.length);
        } else {
            props = new String[input.length];
            for (i = 0; i < props.length; ++i) {
                props[i] = this.getDatabasePropertiesFile();
            }
        }
        for (i = 0; i < input.length; ++i) {
            this.reconnect(props[i]);
            I data = this.load(input[i]);
            AbstractDataProcessorTestCase.assertNotNull((String)("Could not load data for regression test from " + input[i]), data);
            DataContainer backup = (DataContainer)data.getClone();
            OptionHandler current = OptionUtils.shallowCopy((OptionHandler)((OptionHandler)setups[i]), (boolean)false);
            AbstractDataProcessorTestCase.assertNotNull((String)("Failed to create copy of algorithm: " + OptionUtils.getCommandLine(setups[i])), (Object)current);
            if (current instanceof DatabaseConnectionHandler) {
                ((DatabaseConnectionHandler)current).setDatabaseConnection(this.getDatabaseConnection());
            }
            O processed = this.process(data, current);
            AbstractDataProcessorTestCase.assertNotNull((String)"Failed to process data?", processed);
            AbstractDataProcessorTestCase.assertTrue((String)"Input got changed", (boolean)data.equals(backup));
            if (!(current instanceof Destroyable)) continue;
            ((Destroyable)current).destroy();
        }
        for (i = 0; i < setups.length; ++i) {
            if (setups[i] instanceof Destroyable) {
                ((Destroyable)setups[i]).destroy();
                continue;
            }
            if (!(setups[i] instanceof CleanUpHandler)) continue;
            ((CleanUpHandler)setups[i]).cleanUp();
        }
        this.m_Properties = null;
        this.getDatabaseProperties();
    }

    public void testRegression() {
        int i;
        String[] input = this.getRegressionInputFiles();
        String[] output = new String[input.length];
        A[] setups = this.getRegressionSetups();
        int[] ignored = this.getRegressionIgnoredLineIndices();
        String[] props = this.getRegressionConnections();
        AbstractDataProcessorTestCase.assertEquals((String)"Number of files and setups differ!", (int)input.length, (int)setups.length);
        if (props != null) {
            AbstractDataProcessorTestCase.assertEquals((String)"Number of files and connection setups differ!", (int)input.length, (int)props.length);
        } else {
            props = new String[input.length];
            for (i = 0; i < props.length; ++i) {
                props[i] = this.getDatabasePropertiesFile();
            }
        }
        for (i = 0; i < input.length; ++i) {
            this.reconnect(props[i]);
            I data = this.load(input[i]);
            AbstractDataProcessorTestCase.assertNotNull((String)("Could not load data for regression test from " + input[i]), data);
            OptionHandler current = OptionUtils.shallowCopy((OptionHandler)((OptionHandler)setups[i]), (boolean)false);
            AbstractDataProcessorTestCase.assertNotNull((String)("Failed to create copy of algorithm: " + OptionUtils.getCommandLine(setups[i])), (Object)current);
            if (current instanceof DatabaseConnectionHandler) {
                ((DatabaseConnectionHandler)current).setDatabaseConnection(this.getDatabaseConnection());
            }
            O processed = this.process(data, current);
            AbstractDataProcessorTestCase.assertNotNull((String)"Failed to process data?", processed);
            output[i] = this.createOutputFilename(input[i], i);
            boolean ok = this.save(processed, output[i]);
            AbstractDataProcessorTestCase.assertTrue((String)"Failed to save regression data?", (boolean)ok);
            if (!(current instanceof Destroyable)) continue;
            ((Destroyable)current).destroy();
        }
        TmpFile[] outputFiles = new TmpFile[output.length];
        for (i = 0; i < output.length; ++i) {
            outputFiles[i] = new TmpFile(output[i]);
        }
        String regression = this.m_Regression.compare((File[])outputFiles, ignored);
        AbstractDataProcessorTestCase.assertNull((String)("Output differs:\n" + regression), (Object)regression);
        for (i = 0; i < output.length; ++i) {
            if (setups[i] instanceof Destroyable) {
                ((Destroyable)setups[i]).destroy();
            } else if (setups[i] instanceof CleanUpHandler) {
                ((CleanUpHandler)setups[i]).cleanUp();
            }
            this.m_TestHelper.deleteFileFromTmp(output[i]);
        }
        this.cleanUpAfterRegression();
        this.m_Properties = null;
        this.getDatabaseProperties();
    }

    protected void cleanUpAfterRegression() {
    }
}

