/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.CleanUpHandler;
import adams.core.Destroyable;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.data.io.input.AbstractReportReader;
import adams.data.report.Report;
import adams.test.AbstractDatabaseTestCase;
import adams.test.AbstractTestHelper;
import adams.test.Regression;
import adams.test.TestHelper;
import adams.test.TmpFile;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractReportReaderTestCase<A extends AbstractReportReader, D extends Report>
extends AbstractDatabaseTestCase {
    public AbstractReportReaderTestCase(String name) {
        super(name);
    }

    @Override
    protected AbstractTestHelper newTestHelper() {
        return new TestHelper(this, "adams/data/io/input/data");
    }

    protected Vector<D> load(String filename, A reader) {
        this.m_TestHelper.copyResourceToTmp(filename);
        reader.setInput((PlaceholderFile)new TmpFile(filename));
        Vector result = reader.read();
        this.m_TestHelper.deleteFileFromTmp(filename);
        return result;
    }

    protected boolean save(Vector<D> data, String filename, int[] ignored) {
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < data.size(); ++i) {
            output.append("#" + (i + 1) + ":\n");
            List<String> lines = Arrays.asList(((Report)data.get(i)).toString().split("\n"));
            lines = Regression.trim(lines, ignored);
            for (int n = 0; n < lines.size(); ++n) {
                output.append(lines.get(n) + "\n");
            }
            output.append("\n");
        }
        return FileUtils.writeToFile((String)new TmpFile(filename).getAbsolutePath(), (Object)output, (boolean)false);
    }

    protected String[] getRegressionConnections() {
        return null;
    }

    protected abstract String[] getRegressionInputFiles();

    protected abstract A[] getRegressionSetups();

    protected int[] getRegressionIgnoredLineIndices() {
        return new int[0];
    }

    protected String createOutputFilename(String input, int no) {
        String result;
        String ext = "-out" + no;
        int index = input.lastIndexOf(46);
        if (index == -1) {
            result = input + ext;
        } else {
            result = input.substring(0, index);
            result = result + ext;
            result = result + input.substring(index);
        }
        return result;
    }

    public void testRegression() {
        int i;
        String[] input = this.getRegressionInputFiles();
        String[] output = new String[input.length];
        AbstractReportReader[] setups = this.getRegressionSetups();
        int[] ignored = this.getRegressionIgnoredLineIndices();
        String[] props = this.getRegressionConnections();
        AbstractReportReaderTestCase.assertEquals((String)"Number of files and setups differ!", (int)input.length, (int)setups.length);
        if (props != null) {
            AbstractReportReaderTestCase.assertEquals((String)"Number of files and connection setups differ!", (int)input.length, (int)props.length);
        } else {
            props = new String[input.length];
            for (i = 0; i < props.length; ++i) {
                props[i] = this.getDatabasePropertiesFile();
            }
        }
        for (i = 0; i < input.length; ++i) {
            this.reconnect(props[i]);
            AbstractReportReader current = (AbstractReportReader)OptionUtils.shallowCopy((OptionHandler)setups[i], (boolean)false);
            AbstractReportReaderTestCase.assertNotNull((String)("Failed to create copy of algorithm: " + OptionUtils.getCommandLine((Object)setups[i])), (Object)current);
            Vector<D> processed = this.load(input[i], current);
            AbstractReportReaderTestCase.assertNotNull((String)"Failed to read data?", processed);
            output[i] = this.createOutputFilename(input[i], i);
            boolean ok = this.save(processed, output[i], ignored);
            AbstractReportReaderTestCase.assertTrue((String)"Failed to save regression data?", (boolean)ok);
            if (!(current instanceof Destroyable)) continue;
            current.destroy();
        }
        TmpFile[] outputFiles = new TmpFile[output.length];
        for (i = 0; i < output.length; ++i) {
            outputFiles[i] = new TmpFile(output[i]);
        }
        String regression = this.m_Regression.compare((File[])outputFiles);
        AbstractReportReaderTestCase.assertNull((String)("Output differs:\n" + regression), (Object)regression);
        for (i = 0; i < output.length; ++i) {
            if (setups[i] instanceof Destroyable) {
                setups[i].destroy();
            } else if (setups[i] instanceof CleanUpHandler) {
                setups[i].cleanUp();
            }
            this.m_TestHelper.deleteFileFromTmp(output[i]);
        }
        this.cleanUpAfterRegression();
        this.m_Properties = null;
        this.getDatabaseProperties();
    }

    protected void cleanUpAfterRegression() {
    }
}

