/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.condition;

import adams.core.CleanUpHandler;
import adams.core.Destroyable;
import adams.core.io.FileUtils;
import adams.flow.condition.AbstractCondition;
import adams.test.AbstractTestHelper;
import adams.test.AdamsTestCase;
import adams.test.TestHelper;
import adams.test.TmpFile;
import java.io.File;

public abstract class AbstractConditionTestCase
extends AdamsTestCase {
    public AbstractConditionTestCase(String name) {
        super(name);
    }

    protected AbstractTestHelper newTestHelper() {
        return new TestHelper(this, "adams/flow/condition/data");
    }

    protected abstract AbstractCondition[] getRegressionSetups();

    protected String createOutputFilename(AbstractCondition cond, int no) {
        return cond.getClass().getName() + "-out" + no + ".txt";
    }

    protected boolean save(String data, String filename) {
        return FileUtils.writeToFile((String)new TmpFile(filename).getAbsolutePath(), (Object)data, (boolean)false);
    }

    public void testRegression() {
        int i;
        AbstractCondition[] setups = this.getRegressionSetups();
        String[] output = new String[setups.length];
        AbstractConditionTestCase.assertEquals((String)"Number of files and setups differ!", (int)output.length, (int)setups.length);
        for (i = 0; i < output.length; ++i) {
            String processed = setups[i].performTest();
            output[i] = this.createOutputFilename(setups[i], i);
            boolean ok = this.save(processed == null ? "passed" : processed, output[i]);
            AbstractConditionTestCase.assertTrue((String)"Failed to save regression data?", (boolean)ok);
        }
        TmpFile[] outputFiles = new TmpFile[output.length];
        for (i = 0; i < output.length; ++i) {
            outputFiles[i] = new TmpFile(output[i]);
        }
        String regression = this.m_Regression.compare((File[])outputFiles);
        AbstractConditionTestCase.assertNull((String)("Output differs:\n" + regression), (Object)regression);
        for (i = 0; i < output.length; ++i) {
            if (setups[i] instanceof Destroyable) {
                setups[i].destroy();
            } else if (setups[i] instanceof CleanUpHandler) {
                ((CleanUpHandler)setups[i]).cleanUp();
            }
            this.m_TestHelper.deleteFileFromTmp(output[i]);
        }
        this.cleanUpAfterRegression();
    }

    protected void cleanUpAfterRegression() {
    }
}

