/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.base.BaseString;
import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.control.Injector;
import adams.flow.core.AbstractActor;
import adams.flow.core.Token;
import adams.flow.sink.DumpFile;
import adams.flow.source.StringConstants;
import adams.test.TmpFile;
import java.io.File;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestSuite;

public class InjectorTest
extends AbstractFlowTest {
    public InjectorTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public AbstractActor getActor() {
        StringConstants ids = new StringConstants();
        ids.setStrings(new BaseString[]{new BaseString("1"), new BaseString("2"), new BaseString("3"), new BaseString("4"), new BaseString("5"), new BaseString("6"), new BaseString("7"), new BaseString("8"), new BaseString("9"), new BaseString("10")});
        Injector in1 = new Injector();
        in1.setEveryNth(1);
        in1.setLocation(Injector.Location.AFTER);
        in1.setInjection("Inj_1");
        Injector in2 = new Injector();
        in2.setEveryNth(2);
        in2.setLocation(Injector.Location.AFTER);
        in2.setInjection("Inj_2");
        Injector in3 = new Injector();
        in3.setEveryNth(3);
        in3.setLocation(Injector.Location.BEFORE);
        in3.setInjection("Inj_3");
        DumpFile df = new DumpFile();
        df.setAppend(true);
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.txt"));
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{ids, in1, in2, in3, df});
        return flow;
    }

    protected void performTest(Injector actor, String[] strIn, String[] strOut) {
        int i;
        InjectorTest.assertNull((String)"problem with setUp()", (Object)actor.setUp());
        Vector<String> generated = new Vector<String>();
        for (i = 0; i < strIn.length; ++i) {
            actor.input(new Token((Object)strIn[i]));
            InjectorTest.assertNull((String)"problem with execute()", (Object)actor.execute());
            while (actor.hasPendingOutput()) {
                Token out = actor.output();
                InjectorTest.assertNotNull((String)"problem with output()", (Object)out);
                String strOutActor = (String)out.getPayload();
                generated.add(strOutActor);
            }
        }
        InjectorTest.assertEquals((String)"lengths differ", (int)strOut.length, (int)generated.size());
        for (i = 0; i < strOut.length; ++i) {
            InjectorTest.assertEquals((String)("values differ at #" + (i + 1)), (String)strOut[i], (String)((String)generated.get(i)));
        }
        actor.wrapUp();
        actor.cleanUp();
    }

    public void testActorTypical() {
        Injector actor = new Injector();
        String[] strIn = new String[]{"1", "2", "3"};
        String[] strOut = new String[]{"1", "inject_me", "2", "inject_me", "3", "inject_me"};
        this.performTest(actor, strIn, strOut);
    }

    public void testDifferentInjectionString() {
        Injector actor = new Injector();
        actor.setInjection("hello");
        String[] strIn = new String[]{"1", "2", "3"};
        String[] strOut = new String[]{"1", "hello", "2", "hello", "3", "hello"};
        this.performTest(actor, strIn, strOut);
    }

    public void testActorLocationBefore() {
        Injector actor = new Injector();
        actor.setLocation(Injector.Location.BEFORE);
        String[] strIn = new String[]{"1", "2", "3"};
        String[] strOut = new String[]{"inject_me", "1", "inject_me", "2", "inject_me", "3"};
        this.performTest(actor, strIn, strOut);
    }

    public void testActorAfterEvery2nd() {
        Injector actor = new Injector();
        actor.setLocation(Injector.Location.AFTER);
        actor.setEveryNth(2);
        String[] strIn = new String[]{"1", "2", "3", "4"};
        String[] strOut = new String[]{"1", "2", "inject_me", "3", "4", "inject_me"};
        this.performTest(actor, strIn, strOut);
    }

    public void testRegression() {
        this.performRegressionTest((File)((Object)new TmpFile("dumpfile.txt")));
    }

    public static Test suite() {
        return new TestSuite(InjectorTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        InjectorTest.runTest(InjectorTest.suite());
    }
}

