/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.io.PlaceholderFile;
import adams.data.random.AbstractRandomNumberGenerator;
import adams.data.random.JavaRandomInt;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.control.Once;
import adams.flow.core.AbstractActor;
import adams.flow.sink.DumpFile;
import adams.flow.source.RandomNumberGenerator;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class OnceTest
extends AbstractFlowTest {
    public OnceTest(String name) {
        super(name);
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("dumpfile-once.txt");
        this.m_TestHelper.deleteFileFromTmp("dumpfile-all.txt");
        super.tearDown();
    }

    public AbstractActor getActor() {
        RandomNumberGenerator rng = new RandomNumberGenerator();
        rng.setGenerator((AbstractRandomNumberGenerator)new JavaRandomInt());
        DumpFile dfOnce = new DumpFile();
        dfOnce.setAppend(true);
        dfOnce.setOutputFile((PlaceholderFile)new TmpFile("dumpfile-once.txt"));
        Once on = new Once();
        on.add(0, (AbstractActor)dfOnce);
        DumpFile dfAll = new DumpFile();
        dfAll.setAppend(true);
        dfAll.setOutputFile((PlaceholderFile)new TmpFile("dumpfile-all.txt"));
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{rng, on, dfAll});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest(new File[]{new TmpFile("dumpfile-once.txt"), new TmpFile("dumpfile-all.txt")});
    }

    public static Test suite() {
        return new TestSuite(OnceTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        OnceTest.runTest(OnceTest.suite());
    }
}

