/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import adams.env.Environment;
import adams.flow.core.AdditionalOptions;
import adams.flow.core.AdditionalOptionsHandlerUtils;
import adams.test.AdamsTestCase;
import java.util.Hashtable;
import junit.framework.Test;
import junit.framework.TestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdditionalOptionsHandlerUtilsTest
extends AdamsTestCase {
    public AdditionalOptionsHandlerUtilsTest(String name) {
        super(name);
    }

    protected void performBreakUpTest(String optStr, Hashtable<String, String> expected) {
        try {
            AdditionalOptions generated = AdditionalOptionsHandlerUtils.breakUpOptions((String)optStr);
            AdditionalOptionsHandlerUtilsTest.assertEquals((String)"Number of stored pairs differ", (int)expected.size(), (int)generated.size());
            AdditionalOptionsHandlerUtilsTest.assertEquals((String)"Different key-value pairs generated", expected, (Object)generated);
        }
        catch (Exception e) {
            AdditionalOptionsHandlerUtilsTest.fail((String)("Exception generated: " + e));
        }
    }

    public void testSingleEmptyBreakUp() {
        String optStr = "";
        Hashtable<String, String> expected = new Hashtable<String, String>();
        this.performBreakUpTest(optStr, expected);
    }

    public void testSinglePairBreakUp() {
        String optStr = "blah=10";
        Hashtable<String, String> expected = new Hashtable<String, String>();
        expected.put("blah", "10");
        this.performBreakUpTest(optStr, expected);
    }

    public void testMultiPairBreakUp() {
        String optStr = "blah=10 hello=world what=the f**k=42";
        Hashtable<String, String> expected = new Hashtable<String, String>();
        expected.put("blah", "10");
        expected.put("hello", "world");
        expected.put("what", "the");
        expected.put("f**k", "42");
        this.performBreakUpTest(optStr, expected);
    }

    public void testInvalidOption() {
        String optStr = "blah=10 hello what=the what:ever";
        Hashtable<String, String> expected = new Hashtable<String, String>();
        expected.put("blah", "10");
        expected.put("what", "the");
        this.performBreakUpTest(optStr, expected);
    }

    public static Test suite() {
        return new TestSuite(AdditionalOptionsHandlerUtilsTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        AdditionalOptionsHandlerUtilsTest.runTest(AdditionalOptionsHandlerUtilsTest.suite());
    }
}

