/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.base.BaseString;
import adams.data.conversion.AbstractConversion;
import adams.data.conversion.StringToDouble;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.core.Token;
import adams.flow.sink.Null;
import adams.flow.source.StringConstants;
import adams.flow.transformer.Convert;
import adams.flow.transformer.Round;
import junit.framework.Test;
import junit.framework.TestSuite;

public class RoundTest
extends AbstractFlowTest {
    public RoundTest(String name) {
        super(name);
    }

    public AbstractActor getActor() {
        StringConstants sc = new StringConstants();
        sc.setStrings(new BaseString[]{new BaseString("1.0"), new BaseString("1"), new BaseString("-10.3"), new BaseString("0.987")});
        StringToDouble s2d = new StringToDouble();
        Convert con = new Convert();
        con.setConversion((AbstractConversion)s2d);
        Round actor = new Round();
        Null nul = new Null();
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{sc, con, actor, nul});
        return flow;
    }

    protected void performTest(Double dblIn, Integer intOut, Round.Action action) {
        Round actor = new Round();
        actor.setAction(action);
        RoundTest.assertNull((String)"problem with setUp()", (Object)actor.setUp());
        actor.input(new Token((Object)dblIn));
        RoundTest.assertNull((String)"problem with execute()", (Object)actor.execute());
        Token out = actor.output();
        RoundTest.assertNotNull((String)"problem with output()", (Object)out);
        Integer intOutActor = (Integer)out.getPayload();
        RoundTest.assertEquals((String)"values differ", (Object)intOut, (Object)intOutActor);
        actor.wrapUp();
        actor.cleanUp();
    }

    public void testActorTypical() {
        Double[] dblIn = new Double[]{123.0, 1.01, -3.8, 1001.00304};
        for (Round.Action action : Round.Action.values()) {
            int i;
            Integer[] intOut = new Integer[dblIn.length];
            block6: for (i = 0; i < intOut.length; ++i) {
                switch (action) {
                    case ROUND: {
                        intOut[i] = (int)Math.round(dblIn[i]);
                        continue block6;
                    }
                    case FLOOR: {
                        intOut[i] = (int)Math.floor(dblIn[i]);
                        continue block6;
                    }
                    case CEILING: {
                        intOut[i] = (int)Math.ceil(dblIn[i]);
                        continue block6;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled action: " + action);
                    }
                }
            }
            for (i = 0; i < dblIn.length; ++i) {
                this.performTest(dblIn[i], intOut[i], action);
            }
        }
    }

    public static Test suite() {
        return new TestSuite(RoundTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        RoundTest.runTest(RoundTest.suite());
    }
}

