/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.base.BaseString;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.core.Token;
import adams.flow.sink.Null;
import adams.flow.source.StringConstants;
import adams.flow.transformer.SequenceToArray;
import adams.flow.transformer.Sort;
import junit.framework.Test;
import junit.framework.TestSuite;

public class SortTest
extends AbstractFlowTest {
    public SortTest(String name) {
        super(name);
    }

    public AbstractActor getActor() {
        StringConstants con = new StringConstants();
        con.setStrings(new BaseString[]{new BaseString("ABCde"), new BaseString("abcde"), new BaseString("ABCDE"), new BaseString("abcDE")});
        SequenceToArray s2a = new SequenceToArray();
        s2a.setArrayLength(4);
        Sort actor = new Sort();
        Null nul = new Null();
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{con, s2a, actor, nul});
        return flow;
    }

    protected void performTest(String[] strIn, String[] strOut, boolean reverse) {
        Sort actor = new Sort();
        actor.setReverse(reverse);
        SortTest.assertNull((String)"problem with setUp()", (Object)actor.setUp());
        actor.input(new Token((Object)strIn));
        SortTest.assertNull((String)"problem with execute()", (Object)actor.execute());
        Token out = actor.output();
        SortTest.assertNotNull((String)"problem with output()", (Object)out);
        String[] strOutActor = (String[])out.getPayload();
        SortTest.assertEquals((String)"array length differs", (int)strOut.length, (int)strOutActor.length);
        for (int i = 0; i < strOut.length; ++i) {
            SortTest.assertEquals((String)"values differ", (String)strOut[i], (String)strOutActor[i]);
        }
        actor.wrapUp();
        actor.cleanUp();
    }

    public void testActorDefault() {
        String[] strIn = new String[]{"abc", "ACB", "ABC", "adef"};
        String[] strOut = new String[]{"ABC", "ACB", "abc", "adef"};
        this.performTest(strIn, strOut, false);
    }

    public void testActorReverse() {
        String[] strIn = new String[]{"abc", "ACB", "ABC", "adef"};
        String[] strOut = new String[]{"adef", "abc", "ACB", "ABC"};
        this.performTest(strIn, strOut, true);
    }

    public static Test suite() {
        return new TestSuite(SortTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        SortTest.runTest(SortTest.suite());
    }
}

