/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.base.BaseString;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.core.Token;
import adams.flow.sink.Null;
import adams.flow.source.StringConstants;
import adams.flow.transformer.StringCut;
import junit.framework.Test;
import junit.framework.TestSuite;

public class StringCutTest
extends AbstractFlowTest {
    public StringCutTest(String name) {
        super(name);
    }

    public AbstractActor getActor() {
        StringConstants con = new StringConstants();
        con.setStrings(new BaseString[]{new BaseString("A:BCde"), new BaseString("ab:cde"), new BaseString("ABC:DE"), new BaseString("abcD:E")});
        StringCut actor = new StringCut();
        actor.setFieldDelimiter(":");
        actor.setFieldIndex("2");
        Null nul = new Null();
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{con, actor, nul});
        return flow;
    }

    protected void performTest(String[] strIn, String[] strOut, int start, int end, String delim, int field) {
        StringCut actor = new StringCut();
        if (start > -1 && end > -1) {
            actor.setCharacterStartPos(start);
            actor.setCharacterEndPos(end);
            actor.setUseCharacterPos(true);
        } else {
            actor.setFieldDelimiter(delim);
            actor.setFieldIndex("" + field);
            actor.setUseCharacterPos(false);
        }
        StringCutTest.assertNull((String)"problem with setUp()", (Object)actor.setUp());
        actor.input(new Token((Object)strIn));
        StringCutTest.assertNull((String)"problem with execute()", (Object)actor.execute());
        Token out = actor.output();
        StringCutTest.assertNotNull((String)"problem with output()", (Object)out);
        String[] strOutActor = (String[])out.getPayload();
        StringCutTest.assertEquals((String)"array length differs", (int)strOut.length, (int)strOutActor.length);
        for (int i = 0; i < strOut.length; ++i) {
            StringCutTest.assertEquals((String)"values differ", (String)strOut[i], (String)strOutActor[i]);
        }
        actor.wrapUp();
        actor.cleanUp();
    }

    public void testActorCharPositions() {
        String[] strIn = new String[]{"abcde", "hello", "world", "bugger"};
        String[] strOut = new String[]{"cde", "llo", "rld", "gge"};
        this.performTest(strIn, strOut, 3, 5, "", -1);
    }

    public void testActorFields() {
        String[] strIn = new String[]{"ab:cde", "hell:o", "w:orld", ":bugger", "blah:"};
        String[] strOut = new String[]{"cde", "o", "orld", "bugger", ""};
        this.performTest(strIn, strOut, -1, -1, ":", 2);
    }

    public static Test suite() {
        return new TestSuite(StringCutTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        StringCutTest.runTest(StringCutTest.suite());
    }
}

