/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.env.Environment;
import adams.gui.core.SearchParameters;
import adams.test.AdamsTestCase;
import junit.framework.Test;
import junit.framework.TestSuite;

public class SearchParametersTest
extends AdamsTestCase {
    public SearchParametersTest(String name) {
        super(name);
    }

    public void testNullSearchString() {
        SearchParameters params = new SearchParameters(null);
        SearchParametersTest.assertTrue((String)"matching non-empty string", (boolean)params.matches("hello"));
        SearchParametersTest.assertFalse((String)"matching 0", (boolean)params.matches(Integer.valueOf(0)));
        SearchParametersTest.assertFalse((String)"matching !0", (boolean)params.matches(Integer.valueOf(42)));
        SearchParametersTest.assertFalse((String)"matching 0.0", (boolean)params.matches(Double.valueOf(0.0)));
        SearchParametersTest.assertFalse((String)"matching !0.0", (boolean)params.matches(Double.valueOf(42.0)));
    }

    public void testEmptySearchString() {
        SearchParameters params = new SearchParameters("");
        SearchParametersTest.assertTrue((String)"matching non-empty string", (boolean)params.matches("hello"));
        SearchParametersTest.assertFalse((String)"matching 0", (boolean)params.matches(Integer.valueOf(0)));
        SearchParametersTest.assertFalse((String)"matching !0", (boolean)params.matches(Integer.valueOf(42)));
        SearchParametersTest.assertFalse((String)"matching 0.0", (boolean)params.matches(Double.valueOf(0.0)));
        SearchParametersTest.assertFalse((String)"matching !0.0", (boolean)params.matches(Double.valueOf(42.0)));
    }

    public void testSubstringMatching() {
        SearchParameters params = new SearchParameters("h");
        SearchParametersTest.assertTrue((String)"matching non-empty string", (boolean)params.matches("hello"));
        SearchParametersTest.assertFalse((String)"matching 0", (boolean)params.matches(Integer.valueOf(0)));
        SearchParametersTest.assertFalse((String)"matching !0", (boolean)params.matches(Integer.valueOf(42)));
        SearchParametersTest.assertFalse((String)"matching 0.0", (boolean)params.matches(Double.valueOf(0.0)));
        SearchParametersTest.assertFalse((String)"matching !0.0", (boolean)params.matches(Double.valueOf(42.0)));
        params = new SearchParameters("blah");
        SearchParametersTest.assertFalse((String)"matching non-empty string", (boolean)params.matches("hello"));
        SearchParametersTest.assertFalse((String)"matching 0", (boolean)params.matches(Integer.valueOf(0)));
        SearchParametersTest.assertFalse((String)"matching !0", (boolean)params.matches(Integer.valueOf(42)));
        SearchParametersTest.assertFalse((String)"matching 0.0", (boolean)params.matches(Double.valueOf(0.0)));
        SearchParametersTest.assertFalse((String)"matching !0.0", (boolean)params.matches(Double.valueOf(42.1)));
        params = new SearchParameters("42");
        SearchParametersTest.assertFalse((String)"matching non-empty string", (boolean)params.matches("hello"));
        SearchParametersTest.assertFalse((String)"matching 0", (boolean)params.matches(Integer.valueOf(0)));
        SearchParametersTest.assertTrue((String)"matching !0", (boolean)params.matches(Integer.valueOf(42)));
        SearchParametersTest.assertFalse((String)"matching 0.0", (boolean)params.matches(Double.valueOf(0.0)));
        SearchParametersTest.assertFalse((String)"matching !0.0", (boolean)params.matches(Double.valueOf(42.1)));
        params = new SearchParameters("42.1");
        SearchParametersTest.assertFalse((String)"matching non-empty string", (boolean)params.matches("hello"));
        SearchParametersTest.assertFalse((String)"matching 0", (boolean)params.matches(Integer.valueOf(0)));
        SearchParametersTest.assertFalse((String)"matching !0", (boolean)params.matches(Integer.valueOf(42)));
        SearchParametersTest.assertFalse((String)"matching 0.0", (boolean)params.matches(Double.valueOf(0.0)));
        SearchParametersTest.assertTrue((String)"matching !0.0", (boolean)params.matches(Double.valueOf(42.1)));
    }

    public void testRegExpMatching() {
        SearchParameters params = new SearchParameters("h.*", true);
        SearchParametersTest.assertTrue((String)"matching non-empty string", (boolean)params.matches("hello"));
        SearchParametersTest.assertFalse((String)"matching 0", (boolean)params.matches(Integer.valueOf(0)));
        SearchParametersTest.assertFalse((String)"matching !0", (boolean)params.matches(Integer.valueOf(42)));
        SearchParametersTest.assertFalse((String)"matching 0.0", (boolean)params.matches(Double.valueOf(0.0)));
        SearchParametersTest.assertFalse((String)"matching !0.0", (boolean)params.matches(Double.valueOf(42.0)));
        params = new SearchParameters("h", true);
        SearchParametersTest.assertFalse((String)"matching non-empty string", (boolean)params.matches("hello"));
        SearchParametersTest.assertFalse((String)"matching 0", (boolean)params.matches(Integer.valueOf(0)));
        SearchParametersTest.assertFalse((String)"matching !0", (boolean)params.matches(Integer.valueOf(42)));
        SearchParametersTest.assertFalse((String)"matching 0.0", (boolean)params.matches(Double.valueOf(0.0)));
        SearchParametersTest.assertFalse((String)"matching !0.0", (boolean)params.matches(Double.valueOf(42.0)));
        params = new SearchParameters("blah", true);
        SearchParametersTest.assertFalse((String)"matching non-empty string", (boolean)params.matches("hello"));
        SearchParametersTest.assertFalse((String)"matching 0", (boolean)params.matches(Integer.valueOf(0)));
        SearchParametersTest.assertFalse((String)"matching !0", (boolean)params.matches(Integer.valueOf(42)));
        SearchParametersTest.assertFalse((String)"matching 0.0", (boolean)params.matches(Double.valueOf(0.0)));
        SearchParametersTest.assertFalse((String)"matching !0.0", (boolean)params.matches(Double.valueOf(42.1)));
        params = new SearchParameters("42", true);
        SearchParametersTest.assertFalse((String)"matching non-empty string", (boolean)params.matches("hello"));
        SearchParametersTest.assertFalse((String)"matching 0", (boolean)params.matches(Integer.valueOf(0)));
        SearchParametersTest.assertTrue((String)"matching !0", (boolean)params.matches(Integer.valueOf(42)));
        SearchParametersTest.assertFalse((String)"matching 0.0", (boolean)params.matches(Double.valueOf(0.0)));
        SearchParametersTest.assertFalse((String)"matching !0.0", (boolean)params.matches(Double.valueOf(42.1)));
        params = new SearchParameters("42.1", true);
        SearchParametersTest.assertFalse((String)"matching non-empty string", (boolean)params.matches("hello"));
        SearchParametersTest.assertFalse((String)"matching 0", (boolean)params.matches(Integer.valueOf(0)));
        SearchParametersTest.assertFalse((String)"matching !0", (boolean)params.matches(Integer.valueOf(42)));
        SearchParametersTest.assertFalse((String)"matching 0.0", (boolean)params.matches(Double.valueOf(0.0)));
        SearchParametersTest.assertTrue((String)"matching !0.0", (boolean)params.matches(Double.valueOf(42.1)));
        params = new SearchParameters("[0-9][0-9]", true);
        SearchParametersTest.assertTrue((String)"matching non-empty string", (boolean)params.matches("42"));
        SearchParametersTest.assertFalse((String)"matching non-empty string", (boolean)params.matches("421"));
        SearchParametersTest.assertFalse((String)"matching 0", (boolean)params.matches(Integer.valueOf(0)));
        SearchParametersTest.assertFalse((String)"matching !0", (boolean)params.matches(Integer.valueOf(42)));
        SearchParametersTest.assertFalse((String)"matching 0.0", (boolean)params.matches(Double.valueOf(0.0)));
        SearchParametersTest.assertFalse((String)"matching !0.0", (boolean)params.matches(Double.valueOf(42.1)));
    }

    public static Test suite() {
        return new TestSuite(SearchParametersTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        SearchParametersTest.runTest(SearchParametersTest.suite());
    }
}

