/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.core;

import adams.core.CleanUpHandler;
import adams.core.Destroyable;
import adams.core.io.FileUtils;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.gui.visualization.core.AbstractColorProvider;
import adams.test.AbstractTestHelper;
import adams.test.AdamsTestCase;
import adams.test.TestHelper;
import adams.test.TmpFile;
import java.awt.Color;
import java.io.File;
import java.util.Vector;

public abstract class AbstractColorProviderTestCase
extends AdamsTestCase {
    public AbstractColorProviderTestCase(String name) {
        super(name);
    }

    protected AbstractTestHelper newTestHelper() {
        return new TestHelper(this, "adams/gui/visualization/core/data");
    }

    protected Color[] generate(AbstractColorProvider scheme, int numColors) {
        Vector<Color> result = new Vector<Color>();
        scheme.resetColors();
        for (int i = 0; i < numColors; ++i) {
            result.add(scheme.next());
        }
        return result.toArray(new Color[result.size()]);
    }

    protected boolean save(Color[] colors, String filename) {
        StringBuilder content = new StringBuilder();
        for (int i = 0; i < colors.length; ++i) {
            content.append(colors[i].toString() + "\n");
        }
        return FileUtils.writeToFile((String)new TmpFile(filename).getAbsolutePath(), (Object)content, (boolean)false);
    }

    protected abstract int[] getRegressionNumColors();

    protected abstract AbstractColorProvider[] getRegressionSetups();

    protected String createOutputFilename(int no) {
        return "out-" + no + ".txt";
    }

    public void testRegression() {
        int i;
        int[] numColors = this.getRegressionNumColors();
        AbstractColorProvider[] setups = this.getRegressionSetups();
        String[] output = new String[setups.length];
        for (i = 0; i < setups.length; ++i) {
            output[i] = this.createOutputFilename(i);
            AbstractColorProvider current = (AbstractColorProvider)OptionUtils.shallowCopy((OptionHandler)setups[i], (boolean)false);
            AbstractColorProviderTestCase.assertNotNull((String)("Failed to create copy of color provider: " + OptionUtils.getCommandLine((Object)setups[i])), (Object)current);
            Color[] processed = this.generate(current, numColors[i]);
            AbstractColorProviderTestCase.assertNotNull((String)"Failed to generate colors?", (Object)processed);
            AbstractColorProviderTestCase.assertFalse((String)"Failed to generate colors?", (processed.length == 0 ? 1 : 0) != 0);
            boolean ok = this.save(processed, output[i]);
            AbstractColorProviderTestCase.assertTrue((String)"Failed to save regression data?", (boolean)ok);
            if (!(current instanceof Destroyable)) continue;
            current.destroy();
        }
        TmpFile[] outputFiles = new TmpFile[output.length];
        for (i = 0; i < output.length; ++i) {
            outputFiles[i] = new TmpFile(output[i]);
        }
        String regression = this.m_Regression.compare((File[])outputFiles);
        AbstractColorProviderTestCase.assertNull((String)("Output differs:\n" + regression), (Object)regression);
        for (i = 0; i < output.length; ++i) {
            if (setups[i] instanceof Destroyable) {
                setups[i].destroy();
            } else if (setups[i] instanceof CleanUpHandler) {
                ((CleanUpHandler)setups[i]).cleanUp();
            }
            this.m_TestHelper.deleteFileFromTmp(output[i]);
        }
        this.cleanUpAfterRegression();
    }

    protected void cleanUpAfterRegression() {
    }
}

