/*
 * Decompiled with CFR 0.152.
 */
package adams.test;

import adams.core.ClassLister;
import adams.core.ClassLocator;
import adams.core.management.ProcessUtils;
import adams.env.Environment;
import java.util.Collections;
import java.util.HashSet;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdamsTestSuite
extends TestSuite {
    protected static boolean isValidClassname(String classname) {
        return classname.indexOf("$") == -1 && classname.startsWith(Environment.getInstance().getProject() + ".");
    }

    protected static Vector getClassnames(String superclass, Vector<String> packages) {
        Vector result = new Vector();
        HashSet<String> unique = new HashSet<String>();
        Vector names = ClassLocator.find((String)superclass, (String[])packages.toArray(new String[packages.size()]));
        for (int i = 0; i < names.size(); ++i) {
            if (!AdamsTestSuite.isValidClassname((String)names.get(i)) || unique.contains(names.get(i))) continue;
            result.add(names.get(i));
            unique.add((String)names.get(i));
        }
        return result;
    }

    protected static Vector<String> getClassnames(String property) {
        Vector<String> result = new Vector<String>();
        HashSet<String> unique = new HashSet<String>();
        try {
            String[] classes = ClassLister.getSingleton().getClassnames(property);
            for (int i = 0; i < classes.length; ++i) {
                if (!AdamsTestSuite.isValidClassname(classes[i]) || unique.contains(classes[i])) continue;
                result.add(classes[i]);
                unique.add(classes[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    protected static String getTestClassname(String classname) {
        if (!classname.endsWith("Test")) {
            return classname + "Test";
        }
        return classname;
    }

    protected static Class testClassFor(String classname) {
        Class<?> result = null;
        try {
            result = Class.forName(AdamsTestSuite.getTestClassname(classname));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    protected static TestSuite addAll(Vector classnames) {
        TestSuite result = new TestSuite();
        for (int i = 0; i < classnames.size(); ++i) {
            Class tc = AdamsTestSuite.testClassFor((String)classnames.get(i));
            if (tc == null) continue;
            result.addTest((Test)new TestSuite(tc));
        }
        return result;
    }

    public static TestSuite addAll(String property) {
        return AdamsTestSuite.addAll(AdamsTestSuite.getClassnames(property));
    }

    public static TestSuite addAll(String superclass, Vector packages) {
        return AdamsTestSuite.addAll(AdamsTestSuite.getClassnames(superclass, packages));
    }

    protected static Vector getMissing(Vector classnames) {
        Vector<String> result = new Vector<String>();
        for (int i = 0; i < classnames.size(); ++i) {
            if (AdamsTestSuite.testClassFor((String)classnames.get(i)) != null) continue;
            result.add(AdamsTestSuite.getTestClassname((String)classnames.get(i)));
        }
        return result;
    }

    public static Vector getMissing(String property) {
        return AdamsTestSuite.getMissing(AdamsTestSuite.getClassnames(property));
    }

    public static Vector getMissing(String superclass, Vector packages) {
        return AdamsTestSuite.getMissing(AdamsTestSuite.getClassnames(superclass, packages));
    }

    protected static Test suite(Test t, Vector missing) {
        if (missing.size() > 0) {
            Collections.sort(missing);
            System.out.println("Missing Test classes:");
            for (int i = 0; i < missing.size(); ++i) {
                System.out.println("- " + missing.get(i));
            }
            System.out.println();
        }
        return t;
    }

    public static Test suite(String property) {
        return AdamsTestSuite.suite((Test)AdamsTestSuite.addAll(property), AdamsTestSuite.getMissing(property));
    }

    public static Test suite(String superclass, Vector packages) {
        return AdamsTestSuite.suite((Test)AdamsTestSuite.addAll(superclass, packages), AdamsTestSuite.getMissing(superclass, packages));
    }

    public static String getTmpDirectory() {
        return System.getProperty("java.io.tmpdir");
    }

    public static void runTest(Test suite) {
        System.out.println("PID: " + ProcessUtils.getVirtualMachinePID());
        TestRunner.run((Test)suite);
    }
}

