/**
 * VariableName.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.core;

import adams.core.base.BaseString;

/**
 * Wrapper around the name of a variable (= string).
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3308 $
 */
public class VariableName
  extends BaseString {

  /** for serialization. */
  private static final long serialVersionUID = -5338530688258339927L;

  /**
   * Initializes the name with a default value.
   */
  public VariableName() {
    this("variable");
  }

  /**
   * Initializes the object with the string to parse.
   *
   * @param s		the string to parse
   */
  public VariableName(String s) {
    super(s);
  }

  /**
   * Checks whether the string value is a valid presentation for this class.
   *
   * @param value	the string value to check
   * @return		true if a valid variable name
   * @see		Variables#isValidName(String)
   */
  public boolean isValid(String value) {
    return Variables.isValidName(value);
  }

  /**
   * Returns the variable name with start and end tag enclosed.
   *
   * @return		the padded variable name if an actual value available,
   * 			otherwise an empty string
   */
  public String paddedValue() {
    if (getValue().length() > 0)
      return Variables.padName(getValue());
    else
      return "";
  }
}
