/*
 * OptionHandler.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 */

package adams.core.option;

import java.util.Vector;

import adams.core.Destroyable;

/**
 * An interface to indicate that this class can handle commandline options.
 * <p/>
 * Most of the methods only need to be implemented in the superclass, also
 * including the Vector holding the Option objects. Derived classes only
 * override <code>defineOptions()</code> to add more Option objects to the
 * internal Vector.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2427 $
 */
public interface OptionHandler
  extends Destroyable {

  /**
   * Adds options to the internal list of options.
   * <p/>
   * Every subclass needs to add the necessary Option objects to its internal
   * Vector with Option objects.
   */
  public void defineOptions();

  /**
   * Returns the option manager.
   * <p/>
   * Only needs to be implemented in the superclass, which declares the
   * OptionManager object managing all the Option objects.
   *
   * @return		the internal option list
   */
  public OptionManager getOptionManager();

  /**
   * Cleans up the options.
   */
  public void cleanUpOptions();
}
