/*
 * Exp2.java
 * Copyright (C) 2008 University of Waikato, Hamilton, New Zealand
 */

package adams.data.fit;

/**
 <!-- globalinfo-start -->
 * Exponential function of the form:<br/>
 * f(x) = a*e^(b*x) + c*e^(d*x)
 * <p/>
 <!-- globalinfo-end -->
 *
 <!-- options-start -->
 * Valid options are: <p/>
 * 
 * <pre>-D (property: debug)
 *         If set to true, scheme may output additional info to the console.
 * </pre>
 * 
 <!-- options-end -->
 * 
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2537 $
 */
public class Exp2
  extends NonlinearFunction {

  /** for serialization. */
  private static final long serialVersionUID = 1670768051070643034L;

  /**
   * Returns a short description of the function.
   * 
   * @return		a description of the function
   */
  public String globalInfo() {
    return 
    "Exponential function of the form:\n"
    + "f(x) = a*e^(b*x) + c*e^(d*x)";
  }
  
  /**
   * Calculates the partial derivatives based on the x value and the 
   * coefficients.
   * 
   * @param x		the x value
   * @param a		the coefficents
   * @return		the partial derivatives
   */
  public double[] calcDerivatives(double x, double[] a) {
    double[]	result;
    
    result = new double[4];

    if (a.length != result.length)
      throw new IllegalStateException(
	  "Number of coefficients differs from number of partial derivatives: "
	  + a.length + " != " + result.length);
    
    result[0] = Math.exp(a[1] * x);              // e^(b*x)
    result[1] = a[0] * Math.exp(a[1] * x) * x;   // a*(e^(b*x))*x
    result[2] = Math.exp(a[3] * x);              // e^(d*x)
    result[3] = a[2] * Math.exp(a[3] * x) * x;   // c*(e^(d*x))*x
    
    return result;
  }
  
  /**
   * Calculates the y value based on the x value and the coefficients.
   * 
   * @param x		the x value
   * @param a		the coefficents
   * @return		the y value
   */
  public double calcY(double x, double[] a) {
    return a[0] * Math.exp(a[1] * x) + a[2] * Math.exp(a[3] * x);
  }
}
