/**
 * MutableReportHandler.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */
package adams.data.report;

/**
 * Interface for data containers that can set a report as well.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 305 $
 * @param <T> the type of report to handle
 */
public interface MutableReportHandler<T extends Report>
  extends ReportHandler<T> {

  /**
   * Sets a new report.
   *
   * @param value	the new report
   */
  public void setReport(T value);
}
