/*
 * DatabaseConnectionParameterHandler.java
 * Copyright (C) 2009-2011 University of Waikato, Hamilton, New Zealand
 */

package adams.db;

import adams.core.base.BasePassword;

/**
 * For classes that explicitly allow to set database connection parameters,
 * like URL, user and password.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3484 $
 */
public interface DatabaseConnectionParameterHandler {

  /**
   * Sets the database URL to use (only if not connected).
   *
   * @param value	the URL to use
   */
  public void setURL(String value);

  /**
   * Returns the currently set database URL.
   *
   * @return		the current URL
   */
  public String getURL();

  /**
   * Returns the tip text for this property.
   *
   * @return 		tip text for this property suitable for
   * 			displaying in the GUI or for listing the options.
   */
  public String URLTipText();

  /**
   * Sets the database user to use (only if not connected).
   *
   * @param value	the user to use
   */
  public void setUser(String value);

  /**
   * Returns the currently set database user.
   *
   * @return		the current user
   */
  public String getUser();

  /**
   * Returns the tip text for this property.
   *
   * @return 		tip text for this property suitable for
   * 			displaying in the GUI or for listing the options.
   */
  public String userTipText();

  /**
   * Sets the database password to use (only if not connected).
   *
   * @param value	the password to use
   */
  public void setPassword(BasePassword value);

  /**
   * Returns the currently set database password.
   *
   * @return		the current password
   */
  public BasePassword getPassword();

  /**
   * Returns the tip text for this property.
   *
   * @return 		tip text for this property suitable for
   * 			displaying in the GUI or for listing the options.
   */
  public String passwordTipText();
}
