/**
 * WineDefinition.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.env;

import adams.core.management.Wine;

/**
 * Definition for the <a href="http://www.winehq.org/" target="_blank">wine</a> props file.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3846 $
 */
public class WineDefinition
  extends AbstractPropertiesDefinition {

  /** for serialization. */
  private static final long serialVersionUID = 8202332734202753259L;

  /** the key as constant. */
  public final static String KEY = "wine";

  /**
   * Returns the key this definition is for.
   *
   * @return		the key
   */
  public String getKey() {
    return KEY;
  }

  /**
   * Returns the properties file name (no path) this definition is for.
   *
   * @return		the key
   */
  public String getFile() {
    return Wine.FILENAME;
  }

  /**
   * Updates the environment object with its definition for the props file
   * (whether to add/replace/etc the values).
   *
   * @param env		the environment object to update
   */
  public void update(AbstractEnvironment env) {
    add(env, Project.NAME + "/core/management", new String[0]);
  }
}
