/*
 * UndoListener.java
 * Copyright (C) 2008 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.event;

import java.util.EventListener;

/**
 * Interface for classes that listen to Undo events.
 * 
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4 $
 * @see     adams.gui.core.Undo
 */
public interface UndoListener
  extends EventListener {

  /**
   * An undo event, like add or remove, has occurred.
   * 
   * @param e		the trigger event
   */
  public void undoOccurred(UndoEvent e);
}
