/*
 * ClassNode.java
 * Copyright (C) 2009-2011 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.goe.classtree;

import adams.gui.core.dotnotationtree.DotNotationNode;

/**
 * Specialized tree node.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3584 $
 */
public class ClassNode
  extends DotNotationNode {

  /** for serialization. */
  private static final long serialVersionUID = 9062259637831548370L;

  /**
   * Initializes the class node with the specified label (package or class
   * name).
   *
   * @param label	the label for this node
   */
  public ClassNode(String label) {
    super(label);
  }

  /**
   * Returns whether this node represents a leaf node in the sense of the
   * end-point of the dot notation of the full label. Custom trees might
   * have additional information below this actual leaf node.
   *
   * @return		true if leaf
   */
  public boolean isItemLeaf() {
    boolean	result;
    int		i;

    result = true;

    for (i = 0; i < getChildCount(); i++) {
      if (getChildAt(i) instanceof ClassNode) {
	result = false;
	break;
      }
    }

    return result;
  }
}