/**
 * AbstractConditionalDatabaseSelectionPanel.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.selection;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;

import adams.db.AbstractConditions;
import adams.gui.goe.GenericObjectEditorDialog;

/**
 * Abstract ancestor for selection panels that allow a conditional display
 * of the items collected from the database.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 1768 $
 * @param <T> the type of items to display
 * @param <C> the conditions to use for limiting the display
 */
public abstract class AbstractConditionalDatabaseSelectionPanel<T, C extends AbstractConditions>
  extends AbstractDatabaseSelectionPanel<T> {

  /** for serialization. */
  private static final long serialVersionUID = 6833350757448286729L;

  /** the button for setting the name retrieval options. */
  protected JButton m_ButtonOptions;

  /** the conditions for retrieving the items. */
  protected C m_Conditions;

  /**
   * For initializing members.
   */
  protected void initialize() {
    super.initialize();

    m_Conditions = getDefaultConditions();
  }

  /**
   * initializes the GUI elements.
   */
  protected void initGUI() {
    super.initGUI();

    m_ButtonOptions = new JButton("Options");
    m_ButtonOptions.setMnemonic('p');
    m_ButtonOptions.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	showOptions();
      }
    });
    m_SearchPanel.addToWidgetsPanel(m_ButtonOptions);
  }

  /**
   * Sets the enabled state of the panel.
   *
   * @param value	if true then the components will be enabled
   */
  public void setEnabled(boolean value) {
    super.setEnabled(value);

    m_ButtonOptions.setEnabled(value);
  }

  /**
   * Returns the default conditions to use.
   *
   * @return		the conditions
   */
  protected abstract C getDefaultConditions();

  /**
   * Displays the options for selecting the names.
   */
  protected void showOptions() {
    GenericObjectEditorDialog	dialog;

    dialog = GenericObjectEditorDialog.createDialog(this);
    dialog.getGOEEditor().setCanChangeClassInDialog(false);
    dialog.getGOEEditor().setClassType(AbstractConditions.class);
    dialog.setCurrent(m_Conditions);
    dialog.setLocationRelativeTo(this);
    dialog.setVisible(true);
    if (dialog.getResult() == GenericObjectEditorDialog.APPROVE_OPTION) {
      m_Conditions = (C) dialog.getCurrent();
      refresh();
    }
  }
}
