/*
 * NamedContainer.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.visualization.container;

import adams.data.id.MutableIDHandler;

/**
 * Interface for containers that are have a unique ID string.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 543 $
 */
public interface NamedContainer
  extends MutableIDHandler {

  /**
   * Sets the container's ID.
   *
   * @param value	the new ID
   */
  public void setID(String value);

  /**
   * Returns the container's ID.
   *
   * @return		the ID
   */
  public String getID();

  /**
   * Returns the displayed container's ID.
   *
   * @return		the displayed ID
   */
  public String getDisplayID();
}