/* The following code was generated by JFlex 1.4.2 on 10/17/11 11:29 AM */

/*
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * Scanner.java
 * Copyright (C) 2008,2010 University of Waikato, Hamilton, New Zealand
 */

package adams.parser.booleanexpression;

import java_cup.runtime.SymbolFactory;
import java.io.*;

/**
 * A scanner for boolean expressions.
 *
 * @author FracPete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3900 $
 */

public class Scanner implements java_cup.runtime.Scanner {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int STRING = 2;
  public static final int YYINITIAL = 0;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1, 1
  };

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = {
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 49,  0, 42, 48,  0,  0, 
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
    42, 10, 46,  0,  0,  6, 11,  0, 44, 45,  3,  2, 43,  1, 37,  4, 
    36, 38, 38, 38, 38, 38, 38, 38, 38, 38,  0,  0,  7,  8,  9,  0, 
     0, 41, 41, 41, 41, 35, 41, 41, 41, 34, 41, 41, 41, 41, 40, 41, 
    33, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,  0, 47,  0,  5,  0, 
     0, 18, 21, 29,  0, 16, 17, 24, 31, 27,  0,  0, 19, 32, 28, 23, 
    26, 22, 14, 20, 13, 15,  0, 30, 25, 39,  0,  0, 12,  0,  0,  0
  };

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\2\0\1\1\1\2\1\3\1\4\1\5\1\6\1\7"+
    "\1\10\1\11\1\12\1\13\1\14\1\15\14\1\2\16"+
    "\1\17\1\20\2\16\1\21\1\22\1\23\1\24\1\25"+
    "\1\26\1\27\1\30\1\0\1\31\1\32\1\33\22\0"+
    "\1\34\2\0\1\20\1\0\1\35\1\36\1\37\1\40"+
    "\2\0\1\41\2\0\1\42\2\0\1\43\1\0\1\44"+
    "\3\0\1\45\1\46\2\0\1\47\3\0\1\20\1\50"+
    "\1\0\1\51\1\52\6\0\1\53\1\0\1\54\4\0"+
    "\1\55\1\56\10\0\1\57\1\0\1\60\1\61\5\0"+
    "\1\62\4\0\1\63\1\64\1\65\1\66";

  private static int [] zzUnpackAction() {
    int [] result = new int[140];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\62\0\144\0\226\0\144\0\144\0\144\0\144"+
    "\0\144\0\310\0\144\0\372\0\u012c\0\144\0\144\0\u015e"+
    "\0\u0190\0\u01c2\0\u01f4\0\u0226\0\u0258\0\u028a\0\u02bc\0\u02ee"+
    "\0\u0320\0\u0352\0\u0384\0\u03b6\0\u03e8\0\u041a\0\u044c\0\u047e"+
    "\0\u041a\0\144\0\144\0\144\0\144\0\144\0\u04b0\0\144"+
    "\0\u04e2\0\u0514\0\144\0\144\0\144\0\u0546\0\u0578\0\u05aa"+
    "\0\u05dc\0\u060e\0\u0640\0\u0672\0\u06a4\0\u06d6\0\u0708\0\u073a"+
    "\0\u076c\0\u079e\0\u07d0\0\u0802\0\u0834\0\u0866\0\u0898\0\u041a"+
    "\0\u08ca\0\u08fc\0\u092e\0\u0960\0\144\0\144\0\144\0\144"+
    "\0\u0992\0\u09c4\0\144\0\u09f6\0\u0a28\0\144\0\u0a5a\0\u0a8c"+
    "\0\144\0\u0abe\0\144\0\u0af0\0\u0b22\0\u0b54\0\144\0\144"+
    "\0\u0b86\0\u0bb8\0\144\0\u0bea\0\u0c1c\0\u0c4e\0\u0c80\0\144"+
    "\0\u0cb2\0\144\0\144\0\u0ce4\0\u0d16\0\u0d48\0\u0d7a\0\u0dac"+
    "\0\u0dde\0\144\0\u0e10\0\144\0\u0e42\0\u0e74\0\u0ea6\0\u0ed8"+
    "\0\144\0\144\0\u0f0a\0\u0f3c\0\u0f6e\0\u0fa0\0\u0fd2\0\u1004"+
    "\0\u1036\0\u1068\0\144\0\u109a\0\144\0\144\0\u10cc\0\u10fe"+
    "\0\u1130\0\u1162\0\u1194\0\144\0\u11c6\0\u11f8\0\u122a\0\u125c"+
    "\0\144\0\144\0\144\0\144";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[140];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\3\1\4\1\5\1\6\1\7\1\10\1\11\1\12"+
    "\1\13\1\14\1\15\1\16\1\17\1\20\1\21\1\22"+
    "\1\23\1\24\1\25\1\26\1\27\5\3\1\30\1\31"+
    "\1\3\1\32\2\3\1\33\1\34\1\35\1\36\1\37"+
    "\1\3\1\37\1\3\1\40\1\41\1\42\1\43\1\44"+
    "\1\45\1\46\1\3\2\42\56\47\1\50\1\51\1\3"+
    "\125\0\1\52\27\0\1\53\61\0\1\54\61\0\1\55"+
    "\67\0\1\56\3\0\1\57\72\0\1\60\60\0\1\61"+
    "\60\0\1\62\52\0\1\63\1\64\63\0\1\65\54\0"+
    "\1\66\6\0\1\67\51\0\1\70\6\0\1\71\4\0"+
    "\1\72\55\0\1\73\53\0\1\74\60\0\1\75\6\0"+
    "\1\76\54\0\1\77\100\0\1\41\1\100\1\41\4\0"+
    "\2\41\44\0\1\101\4\0\3\41\4\0\2\41\51\0"+
    "\3\41\4\0\2\41\53\0\1\102\1\37\1\103\1\37"+
    "\35\0\1\104\16\0\3\41\4\0\2\41\10\0\56\47"+
    "\21\0\1\105\1\106\15\0\1\107\21\0\1\110\37\0"+
    "\1\111\44\0\1\112\76\0\1\113\61\0\1\114\57\0"+
    "\1\115\61\0\1\116\52\0\1\117\65\0\1\120\56\0"+
    "\1\121\71\0\1\122\55\0\1\123\5\0\1\124\50\0"+
    "\1\125\52\0\1\126\77\0\1\127\63\0\1\130\43\0"+
    "\1\131\74\0\1\132\52\0\1\133\52\0\1\134\65\0"+
    "\1\135\41\0\1\136\44\0\1\137\56\0\1\102\1\103"+
    "\1\0\1\103\63\0\1\140\32\0\1\141\60\0\1\142"+
    "\56\0\1\143\64\0\1\144\65\0\1\145\64\0\1\146"+
    "\62\0\1\147\51\0\1\150\65\0\1\151\52\0\1\152"+
    "\67\0\1\153\61\0\1\154\73\0\1\155\57\0\1\156"+
    "\74\0\1\137\57\0\1\137\1\0\1\137\46\0\1\157"+
    "\44\0\1\160\63\0\1\161\57\0\1\162\60\0\1\163"+
    "\62\0\1\164\60\0\1\165\70\0\1\166\74\0\1\167"+
    "\56\0\1\170\61\0\1\171\62\0\1\172\63\0\1\173"+
    "\57\0\1\174\42\0\1\175\63\0\1\176\61\0\1\177"+
    "\74\0\1\200\61\0\1\201\50\0\1\202\61\0\1\203"+
    "\63\0\1\204\52\0\1\205\61\0\1\206\70\0\1\207"+
    "\61\0\1\210\104\0\1\211\61\0\1\212\32\0\1\213"+
    "\61\0\1\214\41\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[4750];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\2\0\1\11\1\1\5\11\1\1\1\11\2\1\2\11"+
    "\22\1\5\11\1\1\1\11\1\1\1\0\3\11\22\0"+
    "\1\1\2\0\1\1\1\0\4\11\2\0\1\11\2\0"+
    "\1\11\2\0\1\11\1\0\1\11\3\0\2\11\2\0"+
    "\1\11\3\0\1\1\1\11\1\0\2\11\6\0\1\11"+
    "\1\0\1\11\4\0\2\11\10\0\1\11\1\0\2\11"+
    "\5\0\1\11\4\0\4\11";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[140];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /* user code: */
  // Author: FracPete (fracpete at waikato dot ac dot nz)
  // Version: $Revision: 3900 $
  protected SymbolFactory sf;

  public Scanner(InputStream r, SymbolFactory sf){
    this(r);
    this.sf = sf;
  }
  StringBuilder string = new StringBuilder();


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public Scanner(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public Scanner(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead > 0) {
      zzEndRead+= numRead;
      return false;
    }
    // unlikely but not impossible: read 0 characters, but not at end of stream    
    if (numRead == 0) {
      int c = zzReader.read();
      if (c == -1) {
        return true;
      } else {
        zzBuffer[zzEndRead++] = (char) c;
        return false;
      }     
    }

	// numRead < 0
    return true;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public java_cup.runtime.Symbol next_token() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 27: 
          { return sf.newSymbol("Not qquals", sym.NOT_EQ);
          }
        case 55: break;
        case 35: 
          { return sf.newSymbol("Abs", sym.ABS);
          }
        case 56: break;
        case 15: 
          { return sf.newSymbol("e", sym.E);
          }
        case 57: break;
        case 29: 
          { string.append('\t');
          }
        case 58: break;
        case 21: 
          { string.setLength(0); yybegin(STRING);
          }
        case 59: break;
        case 37: 
          { return sf.newSymbol("Sin", sym.SIN);
          }
        case 60: break;
        case 17: 
          { /* ignore white space. */
          }
        case 61: break;
        case 18: 
          { return sf.newSymbol("Comma", sym.COMMA);
          }
        case 62: break;
        case 14: 
          { return sf.newSymbol("Variable", sym.VARIABLE, new String(yytext()));
          }
        case 63: break;
        case 54: 
          { return sf.newSymbol("LowerCase", sym.LOWERCASE);
          }
        case 64: break;
        case 23: 
          { yybegin(YYINITIAL);
                  return sf.newSymbol("String", sym.STRING, string.toString());
          }
        case 65: break;
        case 49: 
          { return sf.newSymbol("IfElse", sym.IFELSE);
          }
        case 66: break;
        case 4: 
          { return sf.newSymbol("Times", sym.TIMES);
          }
        case 67: break;
        case 46: 
          { return sf.newSymbol("Floor", sym.FLOOR);
          }
        case 68: break;
        case 45: 
          { return sf.newSymbol("False", sym.FALSE);
          }
        case 69: break;
        case 24: 
          { string.append('\\');
          }
        case 70: break;
        case 16: 
          { return sf.newSymbol("Number", sym.NUMBER, new Double(yytext()));
          }
        case 71: break;
        case 38: 
          { return sf.newSymbol("Pow", sym.POW);
          }
        case 72: break;
        case 8: 
          { return sf.newSymbol("Less than", sym.LT);
          }
        case 73: break;
        case 30: 
          { string.append('\r');
          }
        case 74: break;
        case 44: 
          { return sf.newSymbol("Ceil", sym.CEIL);
          }
        case 75: break;
        case 20: 
          { return sf.newSymbol("Right Bracket", sym.RPAREN);
          }
        case 76: break;
        case 41: 
          { return sf.newSymbol("True", sym.TRUE);
          }
        case 77: break;
        case 33: 
          { return sf.newSymbol("Tan", sym.TAN);
          }
        case 78: break;
        case 48: 
          { return sf.newSymbol("Substr", sym.SUBSTR);
          }
        case 79: break;
        case 32: 
          { string.append('\"');
          }
        case 80: break;
        case 50: 
          { return sf.newSymbol("Matches", sym.MATCHES);
          }
        case 81: break;
        case 47: 
          { return sf.newSymbol("Length", sym.LENGTH);
          }
        case 82: break;
        case 9: 
          { return sf.newSymbol("Equals", sym.EQ);
          }
        case 83: break;
        case 40: 
          { return sf.newSymbol("Number", sym.NUMBER, new Double(Double.NaN));
          }
        case 84: break;
        case 6: 
          { return sf.newSymbol("Power", sym.EXPONENT);
          }
        case 85: break;
        case 26: 
          { return sf.newSymbol("Greater or equal than", sym.GE);
          }
        case 86: break;
        case 39: 
          { return sf.newSymbol("Cos", sym.COS);
          }
        case 87: break;
        case 43: 
          { return sf.newSymbol("Sqrt", sym.SQRT);
          }
        case 88: break;
        case 36: 
          { return sf.newSymbol("Log", sym.LOG);
          }
        case 89: break;
        case 53: 
          { return sf.newSymbol("UpperCase", sym.UPPERCASE);
          }
        case 90: break;
        case 28: 
          { return sf.newSymbol("pi", sym.PI);
          }
        case 91: break;
        case 2: 
          { return sf.newSymbol("Minus", sym.MINUS);
          }
        case 92: break;
        case 3: 
          { return sf.newSymbol("Plus", sym.PLUS);
          }
        case 93: break;
        case 31: 
          { string.append('\n');
          }
        case 94: break;
        case 42: 
          { return sf.newSymbol("Rint", sym.RINT);
          }
        case 95: break;
        case 7: 
          { return sf.newSymbol("Modulo", sym.MODULO);
          }
        case 96: break;
        case 25: 
          { return sf.newSymbol("Less or equal than", sym.LE);
          }
        case 97: break;
        case 19: 
          { return sf.newSymbol("Left Bracket", sym.LPAREN);
          }
        case 98: break;
        case 52: 
          { return sf.newSymbol("Number", sym.NUMBER, new Double(Double.NEGATIVE_INFINITY));
          }
        case 99: break;
        case 22: 
          { string.append(yytext());
          }
        case 100: break;
        case 34: 
          { return sf.newSymbol("Exp", sym.EXP);
          }
        case 101: break;
        case 5: 
          { return sf.newSymbol("Division", sym.DIVISION);
          }
        case 102: break;
        case 1: 
          { System.err.println("Illegal character: "+yytext());
          }
        case 103: break;
        case 51: 
          { return sf.newSymbol("Number", sym.NUMBER, new Double(Double.POSITIVE_INFINITY));
          }
        case 104: break;
        case 11: 
          { return sf.newSymbol("Not", sym.NOT);
          }
        case 105: break;
        case 13: 
          { return sf.newSymbol("Or", sym.OR);
          }
        case 106: break;
        case 10: 
          { return sf.newSymbol("Greater than", sym.GT);
          }
        case 107: break;
        case 12: 
          { return sf.newSymbol("And", sym.AND);
          }
        case 108: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
              {     return sf.newSymbol("EOF",sym.EOF);
 }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
