/**
 * StringToFieldTest.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */

package adams.data.conversion;

import adams.core.io.FileUtils;
import adams.data.conversion.StringToField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.test.TmpFile;

/**
 * Tests the StringToField conversion.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3607 $
 */
public class StringToFieldTest
  extends AbstractConversionTestCase {

  /**
   * Constructs the test case. Called by subclasses.
   *
   * @param name 	the name of the test
   */
  public StringToFieldTest(String name) {
    super(name);
  }

  /**
   * Turns the data object into a useful string representation.
   * <p/>
   * Outputs the parseable format.
   *
   * @param data	the object to convert
   * @return		the string representation
   */
  protected String toString(Object data) {
    return ((Field) data).toParseableString();
  }

  /**
   * Returns the input data to use in the regression test.
   *
   * @return		the objects
   */
  protected Object[] getRegressionInput() {
    return new String[]{
	"Blah",
	"numeric[N]",
	"boolean[B]",
	"string[S]",
	"unknown[U]"
    };
  }

  /**
   * Returns the setups to use in the regression test.
   *
   * @return		the setups
   */
  protected AbstractConversion[] getRegressionSetups() {
    StringToField[]	result;

    result = new StringToField[2];
    result[0] = new StringToField();
    result[1] = new StringToField();
    result[1].setDefaultDataType(DataType.NUMERIC);

    return result;
  }

  /**
   * Returns the ignored line indices to use in the regression test.
   *
   * @return		the setups
   */
  protected int[] getRegressionIgnoredLineIndices() {
    return new int[0];
  }
}
