/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

import adams.core.Range;
import adams.core.Utils;
import adams.env.Environment;
import adams.test.AdamsTestCase;
import junit.framework.Test;
import junit.framework.TestSuite;

public class RangeTest
extends AdamsTestCase {
    public RangeTest(String name) {
        super(name);
    }

    public void testHasRange() {
        Range range = new Range();
        RangeTest.assertFalse((boolean)range.hasRange());
        range = new Range("");
        RangeTest.assertFalse((boolean)range.hasRange());
        range = new Range("1");
        RangeTest.assertTrue((boolean)range.hasRange());
        range = new Range("1-5");
        RangeTest.assertTrue((boolean)range.hasRange());
        range = new Range("1", 10);
        RangeTest.assertTrue((boolean)range.hasRange());
        range = new Range("1-5", 10);
        RangeTest.assertTrue((boolean)range.hasRange());
        range = new Range("100", 10);
        RangeTest.assertTrue((boolean)range.hasRange());
        range = new Range("20-100", 10);
        RangeTest.assertTrue((boolean)range.hasRange());
    }

    public void testUninitialized() {
        Range range = new Range();
        RangeTest.assertEquals((int)0, (int)range.getIntIndices().length);
        RangeTest.assertEquals((boolean)false, (boolean)range.isInRange(0));
    }

    public void testSetting() {
        Range range = new Range();
        String str = "1";
        range.setRange(str);
        RangeTest.assertEquals((String)"Range strings differ", (String)str, (String)range.getRange());
        str = "1-10";
        range.setRange(str);
        RangeTest.assertEquals((String)"Range strings differ", (String)str, (String)range.getRange());
        str = "first-10";
        range.setRange(str);
        RangeTest.assertEquals((String)"Range strings differ", (String)str, (String)range.getRange());
        str = "1-last";
        range.setRange(str);
        RangeTest.assertEquals((String)"Range strings differ", (String)str, (String)range.getRange());
        str = "first-last";
        range.setRange(str);
        RangeTest.assertEquals((String)"Range strings differ", (String)str, (String)range.getRange());
    }

    public void testNoRange() {
        Range range = new Range();
        range.setMax(10);
        RangeTest.assertEquals((int)0, (int)range.getIntIndices().length);
        RangeTest.assertEquals((boolean)false, (boolean)range.isInRange(0));
    }

    public void testNoMmax() {
        Range range = new Range();
        range.setRange("1");
        RangeTest.assertEquals((int)0, (int)range.getIntIndices().length);
        RangeTest.assertEquals((boolean)false, (boolean)range.isInRange(0));
    }

    public void testSingleIndex() {
        Range range = new Range();
        range.setRange("1");
        range.setMax(10);
        RangeTest.assertEquals((int)1, (int)range.getIntIndices().length);
        RangeTest.assertEquals((boolean)true, (boolean)range.isInRange(0));
    }

    public void testSingleIndexFirst() {
        Range range = new Range();
        range.setRange("first");
        range.setMax(10);
        RangeTest.assertEquals((int)1, (int)range.getIntIndices().length);
        RangeTest.assertEquals((boolean)true, (boolean)range.isInRange(0));
    }

    public void testSingleIndexSecond() {
        Range range = new Range();
        range.setRange("second");
        range.setMax(10);
        RangeTest.assertEquals((int)1, (int)range.getIntIndices().length);
        RangeTest.assertEquals((boolean)true, (boolean)range.isInRange(1));
    }

    public void testSingleIndexThird() {
        Range range = new Range();
        range.setRange("third");
        range.setMax(10);
        RangeTest.assertEquals((int)1, (int)range.getIntIndices().length);
        RangeTest.assertEquals((boolean)true, (boolean)range.isInRange(2));
    }

    public void testSingleIndexLastMinus2() {
        Range range = new Range();
        range.setRange("last_2");
        range.setMax(10);
        RangeTest.assertEquals((int)1, (int)range.getIntIndices().length);
        RangeTest.assertEquals((boolean)true, (boolean)range.isInRange(7));
    }

    public void testSingleIndexLastMinus1() {
        Range range = new Range();
        range.setRange("last_1");
        range.setMax(10);
        RangeTest.assertEquals((int)1, (int)range.getIntIndices().length);
        RangeTest.assertEquals((boolean)true, (boolean)range.isInRange(8));
    }

    public void testSingleIndexLast() {
        Range range = new Range();
        range.setRange("last");
        range.setMax(10);
        RangeTest.assertEquals((int)1, (int)range.getIntIndices().length);
        RangeTest.assertEquals((boolean)true, (boolean)range.isInRange(9));
    }

    public void testMultipleSingleIndex() {
        Range range = new Range();
        range.setRange("1,2,6,8");
        range.setMax(10);
        RangeTest.assertEquals((int)4, (int)range.getIntIndices().length);
        RangeTest.assertEquals((boolean)true, (boolean)range.isInRange(0));
        RangeTest.assertEquals((boolean)true, (boolean)range.isInRange(1));
        RangeTest.assertEquals((boolean)false, (boolean)range.isInRange(2));
        RangeTest.assertEquals((boolean)false, (boolean)range.isInRange(3));
        RangeTest.assertEquals((boolean)false, (boolean)range.isInRange(4));
        RangeTest.assertEquals((boolean)true, (boolean)range.isInRange(5));
        RangeTest.assertEquals((boolean)false, (boolean)range.isInRange(6));
        RangeTest.assertEquals((boolean)true, (boolean)range.isInRange(7));
        RangeTest.assertEquals((boolean)false, (boolean)range.isInRange(8));
        RangeTest.assertEquals((boolean)false, (boolean)range.isInRange(9));
    }

    public void testSingleIndexOutOfRange() {
        Range range = new Range();
        range.setRange("12");
        range.setMax(10);
        RangeTest.assertEquals((int)0, (int)range.getIntIndices().length);
        RangeTest.assertEquals((boolean)false, (boolean)range.isInRange(11));
    }

    public void testIndexOutOfRange2() {
        Range range = new Range();
        range.setRange("5,12");
        range.setMax(10);
        RangeTest.assertEquals((int)1, (int)range.getIntIndices().length);
        RangeTest.assertEquals((boolean)true, (boolean)range.isInRange(4));
        RangeTest.assertEquals((boolean)false, (boolean)range.isInRange(11));
    }

    public void testRangeOutOfRange() {
        Range range = new Range();
        range.setRange("11-20");
        range.setMax(10);
        RangeTest.assertEquals((int)0, (int)range.getIntIndices().length);
    }

    public void testRangeOutOfRange2() {
        Range range = new Range();
        range.setRange("5-9,11-20");
        range.setMax(10);
        RangeTest.assertEquals((int)5, (int)range.getIntIndices().length);
        RangeTest.assertEquals((boolean)true, (boolean)range.isInRange(4));
        RangeTest.assertEquals((boolean)false, (boolean)range.isInRange(11));
    }

    public void testRangeOutOfRange3() {
        Range range = new Range();
        range.setRange("5-12,15-20");
        range.setMax(10);
        RangeTest.assertEquals((int)6, (int)range.getIntIndices().length);
        RangeTest.assertEquals((boolean)true, (boolean)range.isInRange(4));
        RangeTest.assertEquals((boolean)false, (boolean)range.isInRange(11));
    }

    public void testSingleSubRange() {
        Range range = new Range();
        range.setRange("1-4");
        range.setMax(10);
        RangeTest.assertEquals((int)4, (int)range.getIntIndices().length);
        RangeTest.assertEquals((boolean)true, (boolean)range.isInRange(0));
        RangeTest.assertEquals((boolean)true, (boolean)range.isInRange(1));
        RangeTest.assertEquals((boolean)true, (boolean)range.isInRange(2));
        RangeTest.assertEquals((boolean)true, (boolean)range.isInRange(3));
        RangeTest.assertEquals((boolean)false, (boolean)range.isInRange(4));
        RangeTest.assertEquals((boolean)false, (boolean)range.isInRange(5));
        RangeTest.assertEquals((boolean)false, (boolean)range.isInRange(6));
        RangeTest.assertEquals((boolean)false, (boolean)range.isInRange(7));
        RangeTest.assertEquals((boolean)false, (boolean)range.isInRange(8));
        RangeTest.assertEquals((boolean)false, (boolean)range.isInRange(9));
    }

    public void testMultipleSubRange() {
        Range range = new Range();
        range.setRange("1-4,6-8");
        range.setMax(10);
        RangeTest.assertEquals((int)7, (int)range.getIntIndices().length);
        RangeTest.assertEquals((boolean)true, (boolean)range.isInRange(0));
        RangeTest.assertEquals((boolean)true, (boolean)range.isInRange(1));
        RangeTest.assertEquals((boolean)true, (boolean)range.isInRange(2));
        RangeTest.assertEquals((boolean)true, (boolean)range.isInRange(3));
        RangeTest.assertEquals((boolean)false, (boolean)range.isInRange(4));
        RangeTest.assertEquals((boolean)true, (boolean)range.isInRange(5));
        RangeTest.assertEquals((boolean)true, (boolean)range.isInRange(6));
        RangeTest.assertEquals((boolean)true, (boolean)range.isInRange(7));
        RangeTest.assertEquals((boolean)false, (boolean)range.isInRange(8));
        RangeTest.assertEquals((boolean)false, (boolean)range.isInRange(9));
    }

    public void testMixed() {
        Range range = new Range();
        range.setRange("1-3,4,6-7,8");
        range.setMax(10);
        RangeTest.assertEquals((int)7, (int)range.getIntIndices().length);
        RangeTest.assertEquals((boolean)true, (boolean)range.isInRange(0));
        RangeTest.assertEquals((boolean)true, (boolean)range.isInRange(1));
        RangeTest.assertEquals((boolean)true, (boolean)range.isInRange(2));
        RangeTest.assertEquals((boolean)true, (boolean)range.isInRange(3));
        RangeTest.assertEquals((boolean)false, (boolean)range.isInRange(4));
        RangeTest.assertEquals((boolean)true, (boolean)range.isInRange(5));
        RangeTest.assertEquals((boolean)true, (boolean)range.isInRange(6));
        RangeTest.assertEquals((boolean)true, (boolean)range.isInRange(7));
        RangeTest.assertEquals((boolean)false, (boolean)range.isInRange(8));
        RangeTest.assertEquals((boolean)false, (boolean)range.isInRange(9));
    }

    public void testSingleIndexInverted() {
        Range range = new Range();
        range.setRange("3");
        range.setMax(10);
        range.setInverted(true);
        RangeTest.assertEquals((int)9, (int)range.getIntIndices().length);
        RangeTest.assertEquals((boolean)true, (boolean)range.isInRange(0));
        RangeTest.assertEquals((boolean)true, (boolean)range.isInRange(1));
        RangeTest.assertEquals((boolean)false, (boolean)range.isInRange(2));
        RangeTest.assertEquals((boolean)true, (boolean)range.isInRange(3));
        RangeTest.assertEquals((boolean)true, (boolean)range.isInRange(4));
        RangeTest.assertEquals((boolean)true, (boolean)range.isInRange(5));
        RangeTest.assertEquals((boolean)true, (boolean)range.isInRange(6));
        RangeTest.assertEquals((boolean)true, (boolean)range.isInRange(7));
        RangeTest.assertEquals((boolean)true, (boolean)range.isInRange(8));
        RangeTest.assertEquals((boolean)true, (boolean)range.isInRange(9));
    }

    public void testRangeInverted() {
        Range range = new Range();
        range.setRange("second-5");
        range.setMax(10);
        range.setInverted(true);
        RangeTest.assertEquals((int)6, (int)range.getIntIndices().length);
        RangeTest.assertEquals((boolean)true, (boolean)range.isInRange(0));
        RangeTest.assertEquals((boolean)false, (boolean)range.isInRange(1));
        RangeTest.assertEquals((boolean)false, (boolean)range.isInRange(2));
        RangeTest.assertEquals((boolean)false, (boolean)range.isInRange(3));
        RangeTest.assertEquals((boolean)false, (boolean)range.isInRange(4));
        RangeTest.assertEquals((boolean)true, (boolean)range.isInRange(5));
        RangeTest.assertEquals((boolean)true, (boolean)range.isInRange(6));
        RangeTest.assertEquals((boolean)true, (boolean)range.isInRange(7));
        RangeTest.assertEquals((boolean)true, (boolean)range.isInRange(8));
        RangeTest.assertEquals((boolean)true, (boolean)range.isInRange(9));
    }

    public void testSetIndices() {
        Range range = new Range();
        range.setMax(10);
        range.setIndices(new int[0]);
        RangeTest.assertEquals((String)"", (String)range.getRange());
        range.setIndices(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9});
        RangeTest.assertEquals((String)"1-10", (String)range.getRange());
        range.setIndices(new int[]{0, 1, 3, 4, 6, 7, 9});
        RangeTest.assertEquals((String)"1-2,4-5,7-8,10", (String)range.getRange());
        range.setIndices(new int[]{0, 2, 4, 6, 9});
        RangeTest.assertEquals((String)"1,3,5,7,10", (String)range.getRange());
        range.setIndices(new int[]{0});
        RangeTest.assertEquals((String)"1", (String)range.getRange());
        range.setIndices(new int[]{9});
        RangeTest.assertEquals((String)"10", (String)range.getRange());
        range.setIndices(new int[]{4});
        RangeTest.assertEquals((String)"5", (String)range.getRange());
        range.setIndices(new int[]{0, 9});
        RangeTest.assertEquals((String)"1,10", (String)range.getRange());
    }

    public void testGetSegments() {
        Range range = new Range("first-last");
        range.setMax(5);
        int[][] segments = range.getIntSegments();
        RangeTest.assertEquals((String)"# of segments differs", (int)1, (int)segments.length);
        RangeTest.assertEquals((String)"segments differ", (String)"[0,4]", (String)Utils.arrayToString((Object)segments));
        range = new Range("1-5,10-12,45");
        range.setMax(50);
        segments = range.getIntSegments();
        RangeTest.assertEquals((String)"# of segments differs", (int)3, (int)segments.length);
        RangeTest.assertEquals((String)"segments differ", (String)"[0,4],[9,11],[44,44]", (String)Utils.arrayToString((Object)segments));
    }

    public void testToRange() {
        int[] indices = new int[]{0, 1, 2, 3, 4};
        RangeTest.assertEquals((String)"Range differs", (String)"1-5", (String)Range.toRange((int[])indices).getRange());
        indices = new int[]{0, 1, 3, 4};
        RangeTest.assertEquals((String)"Range differs", (String)"1-2,4-5", (String)Range.toRange((int[])indices).getRange());
        indices = new int[]{0, 3, 6, 8};
        RangeTest.assertEquals((String)"Range differs", (String)"1,4,7,9", (String)Range.toRange((int[])indices).getRange());
    }

    public static Test suite() {
        return new TestSuite(RangeTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        RangeTest.runTest(RangeTest.suite());
    }
}

