/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import adams.core.option.AbstractNumericOptionTest;
import adams.core.option.AbstractOptionTest;
import adams.core.option.OptionHandler;
import adams.env.Environment;
import junit.framework.Test;
import junit.framework.TestSuite;

public class DoubleOptionTest
extends AbstractNumericOptionTest {
    public DoubleOptionTest(String name) {
        super(name);
    }

    protected OptionHandler getOptionHandler() {
        return new DoubleOptionClass();
    }

    protected String getLowerBoundTestProperty() {
        return "doubleObj";
    }

    protected Double getLowerBoundTestValue() {
        return new Double(-100.0);
    }

    protected String getUpperBoundTestProperty() {
        return "doubleObj";
    }

    protected Double getUpperBoundTestValue() {
        return new Double(100.0);
    }

    public static Test suite() {
        return new TestSuite(DoubleOptionTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        DoubleOptionTest.runTest(DoubleOptionTest.suite());
    }

    public static class DoubleOptionClass
    extends AbstractOptionTest.AbstractOptionClass {
        private static final long serialVersionUID = 1181533920136806930L;
        protected double m_DoublePrim;
        protected double[] m_DoublePrimArray;
        protected Double m_DoubleObj;
        protected Double[] m_DoubleObjArray;

        public void defineOptions() {
            super.defineOptions();
            this.m_OptionManager.add("double-prim", "doublePrim", (Object)1.0);
            this.m_OptionManager.add("double-prim-array", "doublePrimArray", (Object)new double[]{1.0, 2.0, 3.0});
            this.m_OptionManager.add("double-obj", "doubleObj", (Object)new Double(2.0), (Number)new Double(-10.0), (Number)new Double(10.0));
            this.m_OptionManager.add("double-obj-array", "doubleObjArray", (Object)new Double[]{new Double(4.0), new Double(5.0), new Double(6.0)});
        }

        public void setDoublePrim(double value) {
            this.m_DoublePrim = value;
        }

        public double getDoublePrim() {
            return this.m_DoublePrim;
        }

        public String doublePrimTipText() {
            return "doublePrim";
        }

        public void setDoublePrimArray(double[] value) {
            this.m_DoublePrimArray = value;
        }

        public double[] getDoublePrimArray() {
            return this.m_DoublePrimArray;
        }

        public String doublePrimArrayTipText() {
            return "doublePrimArray";
        }

        public void setDoubleObj(Double value) {
            this.m_DoubleObj = value;
        }

        public Double getDoubleObj() {
            return this.m_DoubleObj;
        }

        public String doubleObjTipText() {
            return "doubleObj";
        }

        public void setDoubleObjArray(Double[] value) {
            this.m_DoubleObjArray = value;
        }

        public Double[] getDoubleObjArray() {
            return this.m_DoubleObjArray;
        }

        public String doubleObjArrayTipText() {
            return "doubleObjArray";
        }
    }
}

