/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import adams.core.option.AbstractNumericOptionTest;
import adams.core.option.AbstractOptionTest;
import adams.core.option.OptionHandler;
import adams.env.Environment;
import junit.framework.Test;
import junit.framework.TestSuite;

public class IntegerOptionTest
extends AbstractNumericOptionTest {
    public IntegerOptionTest(String name) {
        super(name);
    }

    protected OptionHandler getOptionHandler() {
        return new IntegerOptionClass();
    }

    protected String getLowerBoundTestProperty() {
        return "integerObj";
    }

    protected Integer getLowerBoundTestValue() {
        return new Integer(-100);
    }

    protected String getUpperBoundTestProperty() {
        return "integerObj";
    }

    protected Integer getUpperBoundTestValue() {
        return new Integer(100);
    }

    public static Test suite() {
        return new TestSuite(IntegerOptionTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        IntegerOptionTest.runTest(IntegerOptionTest.suite());
    }

    public static class IntegerOptionClass
    extends AbstractOptionTest.AbstractOptionClass {
        private static final long serialVersionUID = 8808117463200049431L;
        protected int m_IntegerPrim;
        protected int[] m_IntegerPrimArray;
        protected Integer m_IntegerObj;
        protected Integer[] m_IntegerObjArray;

        public void defineOptions() {
            super.defineOptions();
            this.m_OptionManager.add("int-prim", "intPrim", (Object)1);
            this.m_OptionManager.add("int-prim-array", "intPrimArray", (Object)new int[]{1, 2, 3});
            this.m_OptionManager.add("int-obj", "integerObj", (Object)new Integer(2), (Number)new Integer(-10), (Number)new Integer(10));
            this.m_OptionManager.add("int-obj-array", "integerObjArray", (Object)new Integer[]{new Integer(4), new Integer(5), new Integer(6)});
        }

        public void setIntPrim(int value) {
            this.m_IntegerPrim = value;
        }

        public int getIntPrim() {
            return this.m_IntegerPrim;
        }

        public String intPrimTipText() {
            return "intPrim";
        }

        public void setIntPrimArray(int[] value) {
            this.m_IntegerPrimArray = value;
        }

        public int[] getIntPrimArray() {
            return this.m_IntegerPrimArray;
        }

        public String intPrimArrayTipText() {
            return "intPrimArray";
        }

        public void setIntegerObj(Integer value) {
            this.m_IntegerObj = value;
        }

        public Integer getIntegerObj() {
            return this.m_IntegerObj;
        }

        public String integerObjTipText() {
            return "integerObj";
        }

        public void setIntegerObjArray(Integer[] value) {
            this.m_IntegerObjArray = value;
        }

        public Integer[] getIntegerObjArray() {
            return this.m_IntegerObjArray;
        }

        public String integerObjArrayTipText() {
            return "intObjArray";
        }
    }
}

