/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import adams.core.base.BaseString;
import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractOptionConsumer;
import adams.core.option.AbstractOptionConsumerTestCase;
import adams.core.option.NestedConsumer;
import adams.core.option.OptionHandler;
import adams.data.baseline.AbstractBaselineCorrection;
import adams.data.baseline.SlidingWindow;
import adams.data.conversion.AbstractConversion;
import adams.data.conversion.StringToDouble;
import adams.data.filter.AbstractFilter;
import adams.data.filter.BaselineCorrection;
import adams.data.filter.MultiFilter;
import adams.data.filter.PassThrough;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.sink.DumpFile;
import adams.flow.source.StringConstants;
import adams.flow.transformer.Convert;
import adams.flow.transformer.MathExpression;
import java.util.Arrays;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedConsumerTest
extends AbstractOptionConsumerTestCase<Vector> {
    public NestedConsumerTest(String name) {
        super(name);
    }

    public void testConsumeSimple() {
        DumpFile handler = new DumpFile();
        handler.setDebugLevel(1);
        handler.setOutputFile(new PlaceholderFile("${TMP}/dumpfile.csv"));
        handler.setAppend(true);
        Vector<Object> input = new Vector<Object>();
        input.add("adams.flow.sink.DumpFile");
        Vector<String> options = new Vector<String>();
        input.add(options);
        options.addAll(Arrays.asList("-D", "1", "-output", "${TMP}/dumpfile.csv", "-append"));
        this.performInputTest((AbstractOptionConsumer)new NestedConsumer(), input, (OptionHandler)handler);
    }

    public void testFromStringSimple() {
        DumpFile handler = new DumpFile();
        handler.setDebugLevel(1);
        handler.setOutputFile(new PlaceholderFile("${TMP}/dumpfile.csv"));
        handler.setAppend(true);
        this.performFromStringTest(NestedConsumer.class, "adams.flow.sink.DumpFile\n\t-D\n\t1\n\t-output\n\t${TMP}/dumpfile.csv\n\t-append\n", (OptionHandler)handler);
    }

    public void testConsumeDeep() {
        MultiFilter handler = new MultiFilter();
        handler.setDebugLevel(1);
        AbstractFilter[] filters = new AbstractFilter[2];
        filters[0] = new PassThrough();
        filters[0].setDebugLevel(2);
        filters[1] = new MultiFilter();
        filters[1].setDebugLevel(3);
        handler.setSubFilters(filters);
        Vector<Object> input = new Vector<Object>();
        input.add("adams.data.filter.MultiFilter");
        Vector<Object> options = new Vector<Object>();
        input.add(options);
        options.add("-D");
        options.add("1");
        options.add("-filter");
        Vector<Object> filter1 = new Vector<Object>();
        options.add(filter1);
        filter1.add("adams.data.filter.PassThrough");
        Vector<String> options1 = new Vector<String>();
        filter1.add(options1);
        options1.add("-D");
        options1.add("2");
        options.add("-filter");
        Vector<Object> filter2 = new Vector<Object>();
        options.add(filter2);
        filter2.add("adams.data.filter.MultiFilter");
        Vector<Object> options2 = new Vector<Object>();
        filter2.add(options2);
        options2.add("-D");
        options2.add("3");
        options2.add("-filter");
        Vector<String> filter3 = new Vector<String>();
        options2.add(filter3);
        filter3.add("adams.data.filter.PassThrough");
        this.performInputTest((AbstractOptionConsumer)new NestedConsumer(), input, (OptionHandler)handler);
    }

    public void testFromStringDeep() {
        MultiFilter handler = new MultiFilter();
        handler.setDebugLevel(1);
        AbstractFilter[] filters = new AbstractFilter[2];
        filters[0] = new PassThrough();
        filters[0].setDebugLevel(2);
        filters[1] = new MultiFilter();
        filters[1].setDebugLevel(3);
        handler.setSubFilters(filters);
        this.performFromStringTest(NestedConsumer.class, "adams.data.filter.MultiFilter\n\t-D\n\t1\n\t-filter\n\t\tadams.data.filter.PassThrough\n\t\t\t-D\n\t\t\t2\n\t-filter\n\t\tadams.data.filter.MultiFilter\n\t\t\t-D\n\t\t\t3\n\t\t\t-filter\n\t\t\t\tadams.data.filter.PassThrough\n", (OptionHandler)handler);
    }

    public void testConsumeDeep2() {
        BaselineCorrection handler = new BaselineCorrection();
        SlidingWindow baselineObj = new SlidingWindow();
        baselineObj.setDebugLevel(2);
        handler.setBaselineCorrection((AbstractBaselineCorrection)baselineObj);
        Vector<Object> input = new Vector<Object>();
        input.add("adams.data.filter.BaselineCorrection");
        Vector<Object> options = new Vector<Object>();
        input.add(options);
        options.add("-baseline");
        Vector<Object> baseline = new Vector<Object>();
        options.add(baseline);
        baseline.add("adams.data.baseline.SlidingWindow");
        Vector<Object> optionsBase = new Vector<Object>();
        baseline.add(optionsBase);
        optionsBase.add("-D");
        optionsBase.add("2");
        optionsBase.add("-baseline");
        Vector<String> baseline2 = new Vector<String>();
        optionsBase.add(baseline2);
        baseline2.add("adams.data.baseline.PassThrough");
        this.performInputTest((AbstractOptionConsumer)new NestedConsumer(), input, (OptionHandler)handler);
    }

    public void testFromStringDeep2() {
        BaselineCorrection handler = new BaselineCorrection();
        SlidingWindow baseline = new SlidingWindow();
        baseline.setDebugLevel(2);
        handler.setBaselineCorrection((AbstractBaselineCorrection)baseline);
        this.performFromStringTest(NestedConsumer.class, "adams.data.filter.BaselineCorrection\n\t-baseline\n\t\tadams.data.baseline.SlidingWindow\n\t\t\t-D\n\t\t\t2\n\t\t\t-baseline\n\t\t\t\tadams.data.baseline.PassThrough\n", (OptionHandler)handler);
    }

    public void testFromStringDeep3() {
        Flow handler = new Flow();
        StringConstants sc = new StringConstants();
        sc.setStrings(new BaseString[]{new BaseString("1"), new BaseString("2"), new BaseString("3")});
        StringToDouble s2d = new StringToDouble();
        Convert con = new Convert();
        con.setConversion((AbstractConversion)s2d);
        MathExpression me = new MathExpression();
        me.setExpression("X^2");
        DumpFile df = new DumpFile();
        df.setAppend(true);
        df.setOutputFile(new PlaceholderFile("${TMP}/dumpfile.txt"));
        handler.setActors(new AbstractActor[]{sc, con, me, df});
        this.performFromStringTest(NestedConsumer.class, "adams.flow.control.Flow\n\t-actor\n\t\tadams.flow.source.StringConstants\n\t\t\t-string\n\t\t\t1\n\t\t\t-string\n\t\t\t2\n\t\t\t-string\n\t\t\t3\n\t-actor\n\t\tadams.flow.transformer.Convert\n\t\t\t-conversion\n\t\t\t\tadams.data.conversion.StringToDouble\n\t-actor\n\t\tadams.flow.transformer.MathExpression\n\t\t\t-expression\n\t\t\tX^2\n\t-actor\n\t\tadams.flow.sink.DumpFile\n\t\t\t-output\n\t\t\t${TMP}/dumpfile.txt\n\t\t\t-append\n", (OptionHandler)handler);
    }
}

