/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.CleanUpHandler;
import adams.core.Destroyable;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.data.container.DataContainer;
import adams.data.io.input.AbstractDataContainerReader;
import adams.data.io.input.IncrementalDataContainerReader;
import adams.test.AbstractDatabaseTestCase;
import adams.test.AbstractTestHelper;
import adams.test.Regression;
import adams.test.TestHelper;
import adams.test.TmpFile;
import java.io.File;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDataContainerReaderTestCase<A extends AbstractDataContainerReader, D extends DataContainer>
extends AbstractDatabaseTestCase {
    public AbstractDataContainerReaderTestCase(String name) {
        super(name);
    }

    @Override
    protected AbstractTestHelper newTestHelper() {
        return new TestHelper(this, "adams/data/io/input/data");
    }

    protected Vector<D> load(String filename, A reader) {
        this.m_TestHelper.copyResourceToTmp(filename);
        if (reader.isInputFile()) {
            reader.setInput((PlaceholderFile)new TmpFile(filename));
        } else {
            reader.setInput((PlaceholderFile)new TmpFile());
        }
        Vector result = (Vector)reader.read().clone();
        if (reader instanceof IncrementalDataContainerReader) {
            while (((IncrementalDataContainerReader)reader).hasMoreData()) {
                result.addAll(reader.read());
            }
        }
        this.m_TestHelper.deleteFileFromTmp(filename);
        return result;
    }

    protected boolean save(Vector<D> data, String filename, int[] ignored) {
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < data.size(); ++i) {
            this.m_TestHelper.save(data.get(i), filename);
            List<Object> lines = FileUtils.loadFromFile((File)((Object)new TmpFile(filename)));
            lines = Regression.trim((List<String>)lines, ignored);
            output.append("#" + (i + 1) + ":\n");
            for (int n = 0; n < lines.size(); ++n) {
                output.append((String)lines.get(n) + "\n");
            }
            output.append("\n");
        }
        return FileUtils.writeToFile((String)new TmpFile(filename).getAbsolutePath(), (Object)output, (boolean)false);
    }

    protected String[] getRegressionConnections() {
        return null;
    }

    protected abstract String[] getRegressionInputFiles();

    protected abstract A[] getRegressionSetups();

    protected abstract int[] getRegressionIgnoredLineIndices();

    protected String createOutputFilename(String input, int no) {
        String result;
        String ext = "-out" + no;
        int index = input.lastIndexOf(46);
        if (index == -1) {
            result = input + ext;
        } else {
            result = input.substring(0, index);
            result = result + ext;
            result = result + input.substring(index);
        }
        return result;
    }

    public void testRegression() {
        int i;
        String[] input = this.getRegressionInputFiles();
        String[] output = new String[input.length];
        AbstractDataContainerReader[] setups = this.getRegressionSetups();
        int[] ignored = this.getRegressionIgnoredLineIndices();
        String[] props = this.getRegressionConnections();
        AbstractDataContainerReaderTestCase.assertEquals((String)"Number of files and setups differ!", (int)input.length, (int)setups.length);
        if (props != null) {
            AbstractDataContainerReaderTestCase.assertEquals((String)"Number of files and connection setups differ!", (int)input.length, (int)props.length);
        } else {
            props = new String[input.length];
            for (i = 0; i < props.length; ++i) {
                props[i] = this.getDatabasePropertiesFile();
            }
        }
        for (i = 0; i < input.length; ++i) {
            this.reconnect(props[i]);
            AbstractDataContainerReader current = (AbstractDataContainerReader)OptionUtils.shallowCopy((OptionHandler)setups[i], (boolean)false);
            AbstractDataContainerReaderTestCase.assertNotNull((String)("Failed to create copy of algorithm: " + OptionUtils.getCommandLine((Object)setups[i])), (Object)current);
            Vector<D> processed = this.load(input[i], current);
            AbstractDataContainerReaderTestCase.assertNotNull((String)"Failed to read data?", processed);
            output[i] = this.createOutputFilename(input[i], i);
            boolean ok = this.save(processed, output[i], ignored);
            AbstractDataContainerReaderTestCase.assertTrue((String)"Failed to save regression data?", (boolean)ok);
            if (!(current instanceof Destroyable)) continue;
            current.destroy();
        }
        TmpFile[] outputFiles = new TmpFile[output.length];
        for (i = 0; i < output.length; ++i) {
            outputFiles[i] = new TmpFile(output[i]);
        }
        String regression = this.m_Regression.compare((File[])outputFiles);
        AbstractDataContainerReaderTestCase.assertNull((String)("Output differs:\n" + regression), (Object)regression);
        for (i = 0; i < output.length; ++i) {
            if (setups[i] instanceof Destroyable) {
                setups[i].destroy();
            } else if (setups[i] instanceof CleanUpHandler) {
                setups[i].cleanUp();
            }
            this.m_TestHelper.deleteFileFromTmp(output[i]);
        }
        this.cleanUpAfterRegression();
        this.m_Properties = null;
        this.getDatabaseProperties();
    }

    protected void cleanUpAfterRegression() {
    }
}

