/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.base.BaseRegExp;
import adams.core.base.BaseString;
import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.sink.DumpFile;
import adams.flow.source.SequenceSource;
import adams.flow.source.StringConstants;
import adams.flow.transformer.StringReplace;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class SequenceSourceTest
extends AbstractFlowTest {
    public SequenceSourceTest(String name) {
        super(name);
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public AbstractActor getActor() {
        StringConstants ids = new StringConstants();
        ids.setStrings(new BaseString[]{new BaseString("1"), new BaseString("2"), new BaseString("3")});
        StringReplace sr = new StringReplace();
        sr.setFind(new BaseRegExp("$"));
        sr.setReplace("-blah");
        SequenceSource seq = new SequenceSource();
        seq.setActors(new AbstractActor[]{ids, sr});
        DumpFile df = new DumpFile();
        df.setAppend(true);
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.txt"));
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{seq, df});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)((Object)new TmpFile("dumpfile.txt")));
    }

    public static Test suite() {
        return new TestSuite(SequenceSourceTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        SequenceSourceTest.runTest(SequenceSourceTest.suite());
    }
}

