/*
 * Decompiled with CFR 0.152.
 */
package adams.tools;

import adams.core.CleanUpHandler;
import adams.core.Destroyable;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.db.DatabaseConnectionHandler;
import adams.test.AbstractDatabaseTestCase;
import adams.test.AbstractTestHelper;
import adams.test.TestHelper;
import adams.test.TmpFile;
import adams.tools.AbstractTool;
import adams.tools.InputFileHandler;
import adams.tools.OutputFileGenerator;
import java.io.File;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractToolTestCase<A extends AbstractTool>
extends AbstractDatabaseTestCase {
    public AbstractToolTestCase(String name) {
        super(name);
    }

    @Override
    protected AbstractTestHelper newTestHelper() {
        return new TestHelper(this, "adams/tools/data");
    }

    protected String[] getRegressionConnections() {
        return null;
    }

    protected abstract String[] getRegressionInputFiles();

    protected abstract String[] getRegressionOutputFiles();

    protected abstract A[] getRegressionSetups();

    protected abstract int[] getRegressionIgnoredLineIndices();

    public void testRegression() {
        int i;
        String[] input = this.getRegressionInputFiles();
        String[] output = this.getRegressionOutputFiles();
        AbstractTool[] setups = this.getRegressionSetups();
        int[] ignored = this.getRegressionIgnoredLineIndices();
        String[] props = this.getRegressionConnections();
        if (setups.length == 0) {
            return;
        }
        if (setups[0] instanceof InputFileHandler) {
            AbstractToolTestCase.assertEquals((String)"Number of input files and setups differ!", (int)input.length, (int)setups.length);
        }
        if (setups[0] instanceof OutputFileGenerator) {
            AbstractToolTestCase.assertEquals((String)"Number of output files and setups differ!", (int)output.length, (int)setups.length);
        }
        if (props != null) {
            AbstractToolTestCase.assertEquals((String)"Number of connection props and setups differ!", (int)input.length, (int)setups.length);
        } else {
            props = new String[setups.length];
            for (i = 0; i < props.length; ++i) {
                props[i] = this.getDatabasePropertiesFile();
            }
        }
        for (i = 0; i < setups.length; ++i) {
            this.reconnect(props[i]);
            AbstractTool current = (AbstractTool)OptionUtils.shallowCopy((OptionHandler)setups[i], (boolean)false);
            AbstractToolTestCase.assertNotNull((String)("Failed to create copy of algorithm: " + OptionUtils.getCommandLine((Object)setups[i])), (Object)current);
            if (current instanceof DatabaseConnectionHandler) {
                ((DatabaseConnectionHandler)current).setDatabaseConnection(this.getDatabaseConnection());
            }
            if (current instanceof InputFileHandler) {
                ((InputFileHandler)current).setInputFile((PlaceholderFile)new TmpFile(input[i]));
            }
            if (current instanceof OutputFileGenerator) {
                ((OutputFileGenerator)current).setOutputFile((PlaceholderFile)new TmpFile(output[i]));
            }
            current.run();
            if (!(current instanceof Destroyable)) continue;
            current.destroy();
        }
        TmpFile[] outputFiles = new TmpFile[output.length];
        for (i = 0; i < output.length; ++i) {
            outputFiles[i] = new TmpFile(output[i]);
        }
        String regression = this.m_Regression.compare((File[])outputFiles, ignored);
        AbstractToolTestCase.assertNull((String)("Output differs:\n" + regression), (Object)regression);
        for (i = 0; i < output.length; ++i) {
            if (setups[i] instanceof Destroyable) {
                setups[i].destroy();
            } else if (setups[i] instanceof CleanUpHandler) {
                setups[i].cleanUp();
            }
            this.m_TestHelper.deleteFileFromTmp(output[i]);
        }
        this.cleanUpAfterRegression();
        this.m_Properties = null;
        this.getDatabaseProperties();
    }

    protected void cleanUpAfterRegression() {
    }
}

