/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

import adams.core.CloneHandler;
import adams.core.DateFormat;
import adams.core.DebugHelper;
import adams.core.Mergeable;
import adams.core.Utils;
import adams.env.Environment;
import adams.gui.core.ColorHelper;
import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Properties
extends java.util.Properties
implements Comparable,
Mergeable<Properties>,
CloneHandler<Properties> {
    private static final long serialVersionUID = -4908679921070087606L;
    public static final String COMMENT = "# ";
    private static final int DEBUGLEVEL = DebugHelper.getDebugLevel(Properties.class);

    public Properties() {
        this.initialize();
    }

    public Properties(java.util.Properties defaults) {
        Properties defaultsNew = new Properties();
        Enumeration<?> enm = defaults.propertyNames();
        while (enm.hasMoreElements()) {
            String key = (String)enm.nextElement();
            defaultsNew.setProperty(key, defaults.getProperty(key));
        }
        this.setDefaults(defaultsNew);
        this.initialize();
    }

    public Properties(Properties defaults) {
        super(defaults);
        this.initialize();
    }

    protected void initialize() {
    }

    public void setDefaults(Properties value) {
        this.defaults = value;
    }

    @Override
    public Properties getClone() {
        return (Properties)this.clone();
    }

    private static void debug(String msg) {
        DebugHelper.debug(Properties.class, msg);
    }

    public static Properties read(String name) throws Exception {
        Vector<String> dirs = new Vector<String>();
        dirs.add(name.replaceAll("\\/[^\\/]*$", ""));
        dirs.add(Environment.getInstance().getHome());
        if (!dirs.contains(System.getProperty("user.dir"))) {
            dirs.add(System.getProperty("user.dir"));
        }
        return Properties.read(name, dirs);
    }

    public static Properties read(String name, Vector<String> dirs) throws Exception {
        name = name.replaceAll(".*\\/", "");
        Properties result = new Properties();
        boolean first = true;
        for (int i = 0; i < dirs.size(); ++i) {
            Properties props;
            if (DEBUGLEVEL > 0) {
                Properties.debug("name=" + name + ", dir/" + (i + 1) + "=" + dirs.get(i));
            }
            if (i == 0) {
                try {
                    Enumeration<URL> urls = ClassLoader.getSystemResources(dirs.get(i) + "/" + name);
                    while (urls.hasMoreElements()) {
                        URL url = urls.nextElement();
                        if (DEBUGLEVEL > 1) {
                            Properties.debug("  url=" + url);
                        }
                        if (first) {
                            result.load(url.openStream());
                            first = false;
                            if (DEBUGLEVEL <= 2) continue;
                            Properties.debug("props=" + result.toStringSimple());
                            continue;
                        }
                        props = new Properties();
                        props.load(url.openStream());
                        if (DEBUGLEVEL > 2) {
                            Properties.debug("props=" + props.toStringSimple());
                        }
                        result.mergeWith(props);
                    }
                    continue;
                }
                catch (Exception ex) {
                    System.err.println("Warning, unable to load properties file from system resource: " + dirs.get(i) + "/" + name);
                    continue;
                }
            }
            props = new Properties(result);
            if (DEBUGLEVEL > 1) {
                Properties.debug("  file=" + dirs.get(i) + "/" + name);
            }
            props.load(dirs.get(i) + "/" + name);
            result = props;
            if (DEBUGLEVEL <= 2) continue;
            Properties.debug("props=" + result.toStringSimple());
        }
        return result;
    }

    protected String expandPlaceHolders(String s) {
        String result = s;
        if (s.indexOf(37) > -1 || s.indexOf(36) > -1) {
            result = result.replace("%t", System.getProperty("java.io.tmpdir"));
            result = result.replace("%p", Environment.getInstance().getHome());
            result = result.replace("%h", System.getProperty("user.home"));
            result = result.replace("$HOME", System.getProperty("user.home"));
            result = result.replace("%USERHOME%", System.getProperty("user.home"));
            result = result.replace("%c", System.getProperty("user.dir"));
            result = result.replace("%%", "%");
        }
        return result;
    }

    public Set<String> keySetAll() {
        HashSet<String> result = new HashSet<String>();
        Enumeration<?> enm = this.propertyNames();
        while (enm.hasMoreElements()) {
            result.add((String)enm.nextElement());
        }
        return result;
    }

    public Enumeration<String> propertyNames(String regExp) {
        if (regExp == null || regExp.length() == 0) {
            regExp = ".*";
        }
        Pattern pattern = Pattern.compile(regExp);
        Vector<String> result = new Vector<String>();
        Enumeration<?> enm = this.propertyNames();
        while (enm.hasMoreElements()) {
            String key = (String)enm.nextElement();
            if (!pattern.matcher(key).matches()) continue;
            result.add(key);
        }
        return result.elements();
    }

    public boolean load(String filename) {
        boolean result = true;
        try {
            this.clear();
            File file = new File(filename);
            if (file.exists()) {
                BufferedInputStream stream = new BufferedInputStream(new FileInputStream(filename));
                this.load(stream);
                stream.close();
            } else if (DEBUGLEVEL > 1) {
                Properties.debug("  file '" + filename + "' does not exist - skipped!");
            }
        }
        catch (Exception e) {
            this.clear();
            result = false;
            e.printStackTrace();
        }
        return result;
    }

    public boolean save(String filename) {
        return this.save(filename, null);
    }

    public boolean save(String filename, String comment) {
        boolean result = true;
        try {
            BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(filename));
            this.collapse().store(stream, comment);
            stream.flush();
            stream.close();
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
        }
        return result;
    }

    public String toStringSimple() {
        Hashtable<String, String> values = new Hashtable<String, String>();
        Enumeration<?> names = this.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            values.put(name, this.getProperty(name));
        }
        return values.toString();
    }

    @Override
    public String toString() {
        return this.toString(null);
    }

    public String toString(String comment) {
        String result = null;
        try {
            StringWriter writer = new StringWriter();
            this.collapse().store(writer, comment);
            writer.flush();
            writer.close();
            result = writer.toString();
        }
        catch (Exception e) {
            result = null;
            e.printStackTrace();
        }
        return result;
    }

    public String toComment() {
        return Utils.commentOut(this.toString(), COMMENT);
    }

    public void add(Properties props) {
        this.add(props, null);
    }

    public void add(Properties props, String prefix) {
        Enumeration<?> enm = props.propertyNames();
        while (enm.hasMoreElements()) {
            String key = (String)enm.nextElement();
            if (prefix != null) {
                this.setProperty(prefix + key, props.getProperty(key));
                continue;
            }
            this.setProperty(key, props.getProperty(key));
        }
    }

    public void removeKey(String key) {
        this.remove(key);
    }

    public void removeKeyRecursive(String key) {
        this.removeKey(key);
        if (this.defaults != null) {
            ((Properties)this.defaults).removeKeyRecursive(key);
        }
    }

    public void removeKeys(String regexp) {
        Enumeration<Object> keys = this.keys();
        Vector<String> toRemove = new Vector<String>();
        Pattern pattern = Pattern.compile(regexp);
        while (keys.hasMoreElements()) {
            String key = keys.nextElement().toString();
            if (!pattern.matcher(key).matches()) continue;
            toRemove.add(key);
        }
        for (int i = 0; i < toRemove.size(); ++i) {
            this.remove(toRemove.get(i));
        }
    }

    public void removeKeysRecursive(String regexp) {
        this.removeKeys(regexp);
        if (this.defaults != null) {
            ((Properties)this.defaults).removeKeysRecursive(regexp);
        }
    }

    public boolean hasKey(String key) {
        return this.getProperty(key) != null;
    }

    public void setInteger(String key, Integer value) {
        this.setProperty(key, "" + value);
    }

    public Integer getInteger(String key) {
        return this.getInteger(key, null);
    }

    public Integer getInteger(String key, Integer defValue) {
        Integer result = defValue;
        try {
            String value;
            if (this.hasKey(key) && (value = this.getProperty(key)) != null) {
                result = new Integer(value);
            }
        }
        catch (Exception e) {
            result = defValue;
            System.err.println("Cannot parse integer value of property '" + key + " (" + this.getProperty(key) + ")'! " + "Using default: " + defValue);
        }
        return result;
    }

    public void setDouble(String key, Double value) {
        this.setProperty(key, "" + value);
    }

    public Double getDouble(String key) {
        return this.getDouble(key, null);
    }

    public Double getDouble(String key, Double defValue) {
        Double result = defValue;
        try {
            String value;
            if (this.hasKey(key) && (value = "" + this.getProperty(key)) != null) {
                result = new Double(value);
            }
        }
        catch (Exception e) {
            result = defValue;
            System.err.println("Cannot parse double value of property '" + key + "'! " + "Using default: " + defValue);
        }
        return result;
    }

    public void setBoolean(String key, Boolean value) {
        this.setProperty(key, "" + value);
    }

    public Boolean getBoolean(String key) {
        return this.getBoolean(key, null);
    }

    public Boolean getBoolean(String key, Boolean defValue) {
        Boolean result = defValue;
        try {
            String value;
            if (this.hasKey(key) && (value = this.getProperty(key)) != null) {
                result = new Boolean(value);
            }
        }
        catch (Exception e) {
            result = defValue;
            System.err.println("Cannot parse boolean value of property '" + key + "'! " + "Using default: " + defValue);
        }
        return result;
    }

    public void setDate(String key, Date value) {
        if (value != null) {
            this.setProperty(key, new DateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").format(value));
        }
    }

    public Date getDate(String key) {
        return this.getDate(key, null);
    }

    public Date getDate(String key, Date defValue) {
        Date result = defValue;
        try {
            String value;
            if (this.hasKey(key) && (value = this.getProperty(key)) != null) {
                result = new DateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").parse(value);
            }
        }
        catch (Exception e) {
            result = defValue;
            System.err.println("Cannot parse date value of property '" + key + "'! " + "Using default: " + defValue);
        }
        return result;
    }

    public void setString(String key, String value) {
        this.setProperty(key, value);
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public String getString(String key, String defValue) {
        String value;
        String result = defValue;
        if (result != null) {
            result = this.expandPlaceHolders(result);
        }
        if (this.hasKey(key) && (value = this.getProperty(key)) != null) {
            result = this.expandPlaceHolders(value);
        }
        return result;
    }

    public Color getColor(String key) {
        return this.getColor(key, null);
    }

    public Color getColor(String key, Color defValue) {
        Color result = defValue;
        if (this.hasKey(key)) {
            result = ColorHelper.valueOf(this.getProperty(key));
        }
        return result;
    }

    public void setColor(String key, Color value) {
        this.setProperty(key, ColorHelper.toHex(value));
    }

    @Override
    public void mergeWith(Properties other) {
        HashSet<String> keys = new HashSet<String>();
        keys.addAll(this.stringPropertyNames());
        keys.addAll(other.stringPropertyNames());
        for (String key : keys) {
            if (this.hasKey(key) && other.hasKey(key)) {
                String otherValue;
                String thisValue = this.getProperty(key);
                if (thisValue.equals(otherValue = other.getProperty(key))) continue;
                if (thisValue.length() == 0) {
                    this.setProperty(key, otherValue);
                    continue;
                }
                if (otherValue.length() == 0) {
                    this.setProperty(key, thisValue);
                    continue;
                }
                this.setProperty(key, thisValue + "," + otherValue);
                continue;
            }
            if (!other.hasKey(key)) continue;
            this.setProperty(key, other.getProperty(key));
        }
    }

    public void removeWithPrefix(String prefix) {
        Enumeration<?> enm = this.propertyNames();
        while (enm.hasMoreElements()) {
            String key = (String)enm.nextElement();
            if (!key.startsWith(prefix)) continue;
            this.remove(key);
        }
    }

    public void removeWithSuffix(String suffix) {
        Enumeration<?> enm = this.propertyNames();
        while (enm.hasMoreElements()) {
            String key = (String)enm.nextElement();
            if (!key.endsWith(suffix)) continue;
            this.remove(key);
        }
    }

    public Properties collapse() {
        Properties result = new Properties();
        Enumeration<?> keys = this.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            result.setProperty(key, this.getProperty(key));
        }
        return result;
    }

    public int compareTo(Object o) {
        int result;
        block3: {
            String key;
            if (o == null) {
                return 1;
            }
            if (!(o instanceof Properties)) {
                return -1;
            }
            Properties props = (Properties)o;
            result = !this.keySetAll().containsAll(props.keySetAll()) ? -1 : (!props.keySetAll().containsAll(this.keySetAll()) ? 1 : 0);
            if (result != 0) break block3;
            Enumeration<?> enm = this.propertyNames();
            while (enm.hasMoreElements() && (result = this.getProperty(key = (String)enm.nextElement()).compareTo(props.getProperty(key))) == 0) {
            }
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        return this.compareTo(obj) == 0;
    }

    public static Properties fromComment(String comments) {
        Properties result = new Properties();
        StringReader reader = new StringReader(Utils.unComment(comments.toString(), COMMENT));
        try {
            result.load(reader);
        }
        catch (Exception e) {
            System.err.println("Error obtaining properties from comments:");
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        Environment.setEnvironmentClass(Environment.class);
        Properties props = Properties.read(args[0], Environment.getInstance().getDirectories(args[0]));
        Enumeration<?> names = props.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            System.out.println(name + ": " + props.getProperty(name));
        }
        Properties clone = (Properties)props.clone();
        Properties empty = new Properties();
        System.out.println("original == clone? " + props.equals(clone));
        System.out.println("original == empty? " + props.equals(empty));
    }
}

