/*
 * Decompiled with CFR 0.152.
 */
package adams.data.container;

import adams.core.Utils;
import adams.data.container.DataContainer;
import adams.data.container.DataPoint;
import adams.data.container.DataPointComparator;
import adams.data.id.MutableIDHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDataContainer<T extends DataPoint>
implements DataContainer<T>,
MutableIDHandler {
    private static final long serialVersionUID = 7596037729815376007L;
    protected String m_ID = "";
    protected ArrayList<T> m_Points = new ArrayList();

    @Override
    public void setID(String value) {
        this.m_ID = value;
    }

    @Override
    public String getID() {
        return this.m_ID;
    }

    @Override
    public Object getClone() {
        AbstractDataContainer result;
        try {
            result = (AbstractDataContainer)this.getClass().newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        result.ensureCapacity(this.size());
        result.assign(this);
        Iterator<T> iter = this.iterator();
        while (iter.hasNext()) {
            result.add((T)((DataPoint)((DataPoint)iter.next()).getClone()));
        }
        return result;
    }

    @Override
    public void assign(DataContainer<T> other) {
        this.setID(other.getID());
    }

    @Override
    public DataContainer getHeader() {
        DataContainer result = AbstractDataContainer.newInstance(this);
        result.assign(this);
        return result;
    }

    @Override
    public int compareToHeader(Object o) {
        if (o == null) {
            return 1;
        }
        int result = 0;
        AbstractDataContainer c = (AbstractDataContainer)o;
        if (result == 0) {
            result = Utils.compare((Comparable)((Object)this.getID()), (Comparable)((Object)c.getID()));
        }
        return result;
    }

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        int result = 0;
        if (!(o instanceof AbstractDataContainer)) {
            return -1;
        }
        AbstractDataContainer other = (AbstractDataContainer)o;
        result = new Integer(this.size()).compareTo(new Integer(other.size()));
        if (result == 0) {
            result = this.compareToHeader(o);
        }
        if (result == 0) {
            Iterator<T> iter = this.iterator();
            Iterator<T> iterOther = other.iterator();
            while (iter.hasNext() && result == 0) {
                result = ((DataPoint)iter.next()).compareTo(iterOther.next());
            }
        }
        return result;
    }

    @Override
    public boolean equalsHeader(Object obj) {
        return this.compareToHeader(obj) == 0;
    }

    @Override
    public boolean equals(Object obj) {
        return this.compareTo(obj) == 0;
    }

    protected boolean modifiedListener(boolean modified) {
        return modified;
    }

    @Override
    public synchronized void clear() {
        if (this.m_Points.size() > 0) {
            for (DataPoint point : this) {
                point.setParent(null);
                if (!(point instanceof DataContainer)) continue;
                ((DataContainer)((Object)point)).clear();
            }
            this.m_Points.clear();
            this.modifiedListener(true);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.m_Points.isEmpty();
    }

    public void ensureCapacity(int minCapacity) {
        this.m_Points.ensureCapacity(minCapacity);
    }

    public void trimToSize() {
        this.m_Points.trimToSize();
    }

    @Override
    public synchronized boolean add(T point) {
        boolean modified;
        point.setParent(this);
        int index = Collections.binarySearch(this.m_Points, point, this.getComparator());
        if (index < 0) {
            this.m_Points.add(-index - 1, point);
            modified = true;
        } else {
            this.m_Points.set(index, point);
            modified = true;
        }
        return this.modifiedListener(modified);
    }

    @Override
    public synchronized boolean addAll(Collection points) {
        boolean modified = false;
        for (DataPoint point : points) {
            point.setParent(this);
            int index = Collections.binarySearch(this.m_Points, point, this.getComparator());
            if (index < 0) {
                this.m_Points.add(-index - 1, point);
                modified = true;
                continue;
            }
            this.m_Points.set(index, point);
            modified = true;
        }
        return this.modifiedListener(modified);
    }

    @Override
    public synchronized boolean remove(Object point) {
        if (this.contains(point)) {
            ((DataPoint)point).setParent(null);
        }
        return this.modifiedListener(this.m_Points.remove(point));
    }

    @Override
    public synchronized boolean removeAll(Collection points) {
        for (DataPoint point : points) {
            if (!this.contains(point)) continue;
            point.setParent(null);
        }
        return this.modifiedListener(this.m_Points.removeAll(points));
    }

    @Override
    public synchronized boolean contains(Object point) {
        return this.m_Points.contains(point);
    }

    @Override
    public synchronized boolean containsAll(Collection points) {
        return this.m_Points.containsAll(points);
    }

    @Override
    public synchronized boolean retainAll(Collection points) {
        for (DataPoint point : points) {
            if (this.contains(point)) continue;
            point.setParent(null);
        }
        return this.modifiedListener(this.m_Points.retainAll(points));
    }

    @Override
    public int size() {
        return this.m_Points.size();
    }

    @Override
    public synchronized void mergeWith(DataContainer other) {
        for (DataPoint point : other) {
            if (this.contains(point)) continue;
            this.add((T)point);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this.m_Points.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.m_Points.toArray();
    }

    @Override
    public Object[] toArray(Object[] array) {
        return this.m_Points.toArray(array);
    }

    @Override
    public List<T> toList() {
        return this.m_Points;
    }

    @Override
    public Vector<T> toVector() {
        return this.toVector(this.getComparator());
    }

    @Override
    public Vector<T> toVector(DataPointComparator comparator) {
        Vector<T> result = new Vector<T>(this.m_Points);
        Collections.sort(result, comparator);
        return result;
    }

    @Override
    public TreeSet<T> toTreeSet() {
        return this.toTreeSet(this.getComparator());
    }

    @Override
    public TreeSet<T> toTreeSet(DataPointComparator comparator) {
        TreeSet<T> result = new TreeSet<T>(comparator);
        result.addAll(this.m_Points);
        return result;
    }

    @Override
    public int hashCode() {
        return new String(this.getID() + super.hashCode()).hashCode();
    }

    public String toString() {
        return "ID=" + this.getID() + ", #points=" + this.size();
    }

    public static DataContainer newInstance(DataContainer cont) {
        DataContainer result;
        try {
            result = (DataContainer)cont.getClass().newInstance();
        }
        catch (Exception e) {
            result = null;
            e.printStackTrace();
        }
        return result;
    }
}

