/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.CleanUpHandler;
import adams.core.ShallowCopySupporter;
import adams.core.option.OptionHandlingObject;
import adams.core.option.OptionUtils;
import adams.data.conversion.StreamConversion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConversion
extends OptionHandlingObject
implements CleanUpHandler,
ShallowCopySupporter<AbstractConversion> {
    private static final long serialVersionUID = 1576117521811422376L;
    protected Object m_Owner;
    protected Object m_Input;
    protected Object m_Output;

    @Override
    protected void reset() {
        super.reset();
        this.m_Output = null;
    }

    public void setOwner(Object value) {
        this.m_Owner = value;
        this.reset();
    }

    public Object getOwner() {
        return this.m_Owner;
    }

    public abstract Class accepts();

    public void setInput(Object value) {
        this.m_Input = value;
        if (this instanceof StreamConversion) {
            this.m_Output = null;
        } else {
            this.reset();
        }
    }

    public Object getInput() {
        return this.m_Input;
    }

    public abstract Class generates();

    public Object getOutput() {
        return this.m_Output;
    }

    protected String checkData() {
        if (this.m_Input == null) {
            return "No input data available!";
        }
        if (!this.accepts().isAssignableFrom(this.m_Input.getClass())) {
            return "Data cannot be processed: input=" + this.m_Input.getClass().getName() + ", accepts=" + this.accepts().getName();
        }
        return null;
    }

    protected abstract Object doConvert() throws Exception;

    public String convert() {
        this.m_Output = null;
        String result = this.checkData();
        if (result == null) {
            try {
                this.m_Output = this.doConvert();
            }
            catch (Exception e) {
                String msg = "Failed to convert data (" + this.accepts().getName() + " -> " + this.generates().getName() + "):";
                result = msg + " " + e;
                this.getSystemErr().println(msg);
                this.getSystemErr().printStackTrace(e);
            }
        }
        return result;
    }

    @Override
    public void cleanUp() {
        this.m_Input = null;
        this.m_Output = null;
    }

    @Override
    public AbstractConversion shallowCopy() {
        return this.shallowCopy(false);
    }

    @Override
    public AbstractConversion shallowCopy(boolean expand) {
        return (AbstractConversion)OptionUtils.shallowCopy(this, expand);
    }
}

