/*
 * Decompiled with CFR 0.152.
 */
package adams.data.fit;

import adams.core.ClassLister;
import adams.core.ConsoleObject;
import adams.core.option.OptionHandler;
import adams.core.option.OptionManager;
import adams.core.option.OptionUtils;

public abstract class Fit
extends ConsoleObject
implements OptionHandler {
    private static final long serialVersionUID = 1392766177324738497L;
    public static final double SMALL = 1.0E-7;
    protected OptionManager m_OptionManager;
    protected boolean m_Debug;

    public Fit() {
        this.initialize();
        this.defineOptions();
        this.getOptionManager().setDefaults();
    }

    public abstract String globalInfo();

    protected void initialize() {
    }

    protected OptionManager newOptionManager() {
        return new OptionManager(this);
    }

    public void defineOptions() {
        this.m_OptionManager = this.newOptionManager();
        this.m_OptionManager.add("D", "debug", false);
    }

    public OptionManager getOptionManager() {
        if (this.m_OptionManager == null) {
            this.defineOptions();
        }
        return this.m_OptionManager;
    }

    public void cleanUpOptions() {
        if (this.m_OptionManager != null) {
            this.m_OptionManager.cleanUp();
            this.m_OptionManager = null;
        }
    }

    public void destroy() {
        this.cleanUpOptions();
    }

    public void setDebug(boolean value) {
        this.m_Debug = value;
        this.getDebugging().setEnabled(value);
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    public String debugTipText() {
        return "If set to true, scheme may output additional info to the console.";
    }

    public abstract String getDescription();

    public abstract boolean fit(double[] var1, double[] var2, double[] var3, double[] var4, double[] var5);

    public boolean fitClean(double[] parameters, double[] x, double[] y, double[] sigma_x, double[] sigma_y) {
        boolean result = this.fit(parameters, x, y, sigma_x, sigma_y);
        for (int i = 0; i < parameters.length; ++i) {
            if (!(Math.abs(parameters[i]) < 1.0E-7)) continue;
            parameters[i] = 0.0;
        }
        return result;
    }

    public abstract double calculate(double[] var1, double var2);

    public double[] calculate(double[] parameters, double[] x) {
        double[] result = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            result[i] = this.calculate(parameters, x[i]);
        }
        return result;
    }

    public abstract boolean canGuess();

    public abstract double[] guess(double[] var1, double[] var2);

    public abstract String toString();

    public static String[] getFits() {
        return ClassLister.getSingleton().getClassnames(Fit.class);
    }

    public static Fit forName(String classname, String[] options) {
        Fit result;
        try {
            result = (Fit)OptionUtils.forName(Fit.class, classname, options);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }
}

