/*
 * Decompiled with CFR 0.152.
 */
package adams.data.outlier;

import adams.core.ClassLister;
import adams.core.CleanUpHandler;
import adams.core.Performance;
import adams.core.ShallowCopySupporter;
import adams.core.option.AbstractOptionConsumer;
import adams.core.option.ArrayConsumer;
import adams.core.option.OptionHandlingObject;
import adams.core.option.OptionUtils;
import adams.data.NotesHandler;
import adams.data.container.DataContainer;
import adams.data.id.DatabaseIDHandler;
import adams.multiprocess.Job;
import adams.multiprocess.JobList;
import adams.multiprocess.JobRunner;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOutlierDetector<T extends DataContainer>
extends OptionHandlingObject
implements Comparable,
CleanUpHandler,
ShallowCopySupporter<AbstractOutlierDetector> {
    private static final long serialVersionUID = 1238310227471192973L;

    @Override
    public void reset() {
        super.reset();
    }

    @Override
    public void cleanUp() {
        this.reset();
    }

    @Override
    public void destroy() {
        this.cleanUp();
        super.destroy();
    }

    public Vector<String> detect(T data) {
        this.checkData(data);
        Vector<String> result = this.processData(data);
        return result;
    }

    protected void checkData(T data) {
        if (data == null) {
            throw new IllegalStateException("No input data provided!");
        }
    }

    protected abstract Vector<String> processData(T var1);

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        return OptionUtils.getCommandLine(this).compareTo(OptionUtils.getCommandLine(o));
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    @Override
    public AbstractOutlierDetector shallowCopy() {
        return this.shallowCopy(false);
    }

    @Override
    public AbstractOutlierDetector shallowCopy(boolean expand) {
        return (AbstractOutlierDetector)OptionUtils.shallowCopy(this, expand);
    }

    public static String[] getOutlierDetectors() {
        return ClassLister.getSingleton().getClassnames(AbstractOutlierDetector.class);
    }

    public static AbstractOutlierDetector forName(String classname, String[] options) {
        AbstractOutlierDetector result;
        try {
            result = (AbstractOutlierDetector)OptionUtils.forName(AbstractOutlierDetector.class, classname, options);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static AbstractOutlierDetector forCommandLine(String cmdline) {
        return (AbstractOutlierDetector)AbstractOptionConsumer.fromString(ArrayConsumer.class, cmdline);
    }

    public static Vector<String> detect(AbstractOutlierDetector detector, DataContainer data) {
        Vector<DataContainer> dataList = new Vector<DataContainer>();
        dataList.add(data);
        Vector<AbstractOutlierDetector> detectorList = new Vector<AbstractOutlierDetector>();
        detectorList.add(detector);
        Vector<Vector<Vector<String>>> detected = AbstractOutlierDetector.detect(detectorList, dataList);
        Vector<String> result = detected.get(0).get(0);
        return result;
    }

    public static Vector<Vector<String>> detect(AbstractOutlierDetector detector, Vector<DataContainer> data) {
        Vector<DataContainer> dataList = new Vector<DataContainer>();
        dataList.addAll(data);
        Vector<AbstractOutlierDetector> detectorList = new Vector<AbstractOutlierDetector>();
        detectorList.add(detector);
        Vector<Vector<Vector<String>>> detected = AbstractOutlierDetector.detect(detectorList, dataList);
        Vector<Vector<String>> result = detected.get(0);
        return result;
    }

    public static Vector<Vector<String>> detect(Vector<AbstractOutlierDetector> detector, DataContainer data) {
        Vector<DataContainer> dataList = new Vector<DataContainer>();
        dataList.add(data);
        Vector<AbstractOutlierDetector> detectorList = new Vector<AbstractOutlierDetector>();
        detectorList.addAll(detector);
        Vector<Vector<Vector<String>>> detected = AbstractOutlierDetector.detect(detectorList, dataList);
        Vector<Vector<String>> result = new Vector<Vector<String>>();
        for (int i = 0; i < detected.size(); ++i) {
            result.add(detected.get(i).get(0));
        }
        return result;
    }

    public static Vector<Vector<Vector<String>>> detect(Vector<AbstractOutlierDetector> detector, Vector<DataContainer> data) {
        Vector<Vector<Vector<String>>> result = new Vector<Vector<Vector<String>>>();
        if (Performance.getMultiProcessingEnabled()) {
            int i;
            JobRunner runner = new JobRunner();
            JobList<DetectorJob<DataContainer>> jobs = new JobList<DetectorJob<DataContainer>>();
            for (int n = 0; n < detector.size(); ++n) {
                for (i = 0; i < data.size(); ++i) {
                    AbstractOutlierDetector threadDetector = detector.get(n).shallowCopy(true);
                    jobs.add(new DetectorJob<DataContainer>(threadDetector, data.get(i)));
                }
            }
            runner.add(jobs);
            runner.start();
            runner.stop();
            Vector subresult = null;
            for (i = 0; i < jobs.size(); ++i) {
                DetectorJob job;
                if (i % data.size() == 0) {
                    subresult = new Vector();
                    result.add(subresult);
                }
                if ((job = (DetectorJob)jobs.get(i)).getResult() != null) {
                    subresult.add(job.getResult());
                } else {
                    subresult.add(new Vector());
                }
                job.cleanUp();
            }
        } else {
            for (int n = 0; n < detector.size(); ++n) {
                Vector<Vector<String>> subresult = new Vector<Vector<String>>();
                result.add(subresult);
                for (int i = 0; i < data.size(); ++i) {
                    AbstractOutlierDetector threadDetector = detector.get(n).shallowCopy(true);
                    subresult.add(threadDetector.detect(data.get(i)));
                }
            }
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DetectorJob<T extends DataContainer>
    extends Job {
        private static final long serialVersionUID = 4607715174153227144L;
        protected AbstractOutlierDetector m_Detector;
        protected T m_Data;
        protected Vector<String> m_Result;

        public DetectorJob(AbstractOutlierDetector detector, T data) {
            this.m_Detector = detector;
            this.m_Data = data;
            this.m_Result = null;
        }

        public AbstractOutlierDetector getOutlierDetector() {
            return this.m_Detector;
        }

        public T getData() {
            return this.m_Data;
        }

        public Vector<String> getResult() {
            return this.m_Result;
        }

        @Override
        protected String preProcessCheck() {
            if (this.m_Detector == null) {
                return "No detector set!";
            }
            if (this.m_Data == null) {
                return "No data set!";
            }
            return null;
        }

        @Override
        protected void process() {
            this.m_Result = this.m_Detector.detect(this.m_Data);
        }

        @Override
        protected String postProcessCheck() {
            if (this.m_Result == null) {
                return "Result of detector is null!";
            }
            return null;
        }

        @Override
        public void cleanUp() {
            super.cleanUp();
            this.m_Data = null;
            this.m_Detector.destroy();
            this.m_Detector = null;
            this.m_Result = null;
        }

        @Override
        protected String getAdditionalErrorInformation() {
            if (this.m_Data instanceof NotesHandler) {
                return ((NotesHandler)this.m_Data).getNotes().toString();
            }
            return "";
        }

        @Override
        public String toString() {
            String result = "data:" + this.m_Data.getID() + ", ";
            if (this.m_Data instanceof DatabaseIDHandler) {
                result = result + "db-id: " + ((DatabaseIDHandler)this.m_Data).getDatabaseID() + ", ";
            }
            result = result + "filter: " + OptionUtils.getCommandLine(this.m_Detector);
            return result;
        }
    }
}

